/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.ToolRun;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.util.ArrayList;
import java.util.List;

public class SeismicPhaseSegment {
    TauModel tMod;
    int startBranch;
    int endBranch;
    boolean isPWave;
    PhaseInteraction endAction;
    PhaseInteraction prevEndAction = null;
    boolean isDownGoing;
    boolean isFlat = false;
    double flatFractionOfPath = 1.0;
    String legName;

    public SeismicPhaseSegment(TauModel tMod, int startBranch, int endBranch, boolean isPWave, PhaseInteraction endAction, boolean isDownGoing, String legName) {
        this.tMod = tMod;
        this.startBranch = startBranch;
        this.endBranch = endBranch;
        this.isPWave = isPWave;
        this.endAction = endAction;
        this.isDownGoing = isDownGoing;
        this.legName = legName;
    }

    public boolean endsAtTop() throws TauModelException {
        switch (this.endAction) {
            case END: 
            case HEAD: 
            case TRANSUP: 
            case REFLECT_UNDERSIDE: 
            case REFLECT_UNDERSIDE_CRITICAL: {
                return true;
            }
            case TURN: 
            case DIFFRACT: 
            case END_DOWN: 
            case TRANSDOWN: 
            case REFLECT_TOPSIDE: 
            case REFLECT_TOPSIDE_CRITICAL: {
                return false;
            }
            case START: {
                return !this.isDownGoing;
            }
        }
        throw new TauModelException("endAction should never be FAIL or default in SeismicPhaseSegment");
    }

    public static String endActionToString(PhaseInteraction endAction) {
        String action;
        switch (endAction) {
            case START: {
                action = "start";
                break;
            }
            case TURN: {
                action = "turn";
                break;
            }
            case REFLECT_UNDERSIDE: {
                action = "reflect underside";
                break;
            }
            case END_DOWN: {
                action = "end downward";
                break;
            }
            case REFLECT_UNDERSIDE_CRITICAL: {
                action = "critical reflect underside";
                break;
            }
            case REFLECT_TOPSIDE: {
                action = "reflect topside";
                break;
            }
            case REFLECT_TOPSIDE_CRITICAL: {
                action = "critical reflect topside";
                break;
            }
            case TRANSUP: {
                action = "transmit up";
                break;
            }
            case TRANSDOWN: {
                action = "transmit down";
                break;
            }
            case DIFFRACT: {
                action = "diffract";
                break;
            }
            case HEAD: {
                action = "head wave";
                break;
            }
            case SCATTER: {
                action = "scatter";
                break;
            }
            case SCATTER_DOWN: {
                action = "down scatter";
                break;
            }
            case BACKSCATTER: {
                action = "backscatter";
                break;
            }
            case BACKSCATTER_DOWN: {
                action = "down backscatter";
                break;
            }
            case END: {
                action = "end";
                break;
            }
            case FAIL: {
                action = "fail";
                break;
            }
            default: {
                action = "unknown";
            }
        }
        return action;
    }

    public String describeBranchRange(int startBranch, int endBranch) {
        String out = "";
        out = startBranch < this.tMod.getMohoBranch() && endBranch < this.tMod.getMohoBranch() ? "crust" : (startBranch < this.tMod.getCmbBranch() && endBranch < this.tMod.getCmbBranch() ? (startBranch < this.tMod.getMohoBranch() && endBranch >= this.tMod.getMohoBranch() ? "crust/mantle" : (startBranch >= this.tMod.getMohoBranch() && endBranch < this.tMod.getMohoBranch() ? "crust/mantle" : "mantle")) : (startBranch <= this.tMod.getIocbBranch() && endBranch <= this.tMod.getIocbBranch() ? "outer core" : "inner core"));
        return out;
    }

    public String toString() {
        String isPString;
        Object desc = "";
        String upDown = this.isFlat ? "flat" : (this.isDownGoing ? "down" : "up  ");
        String action = SeismicPhaseSegment.endActionToString(this.endAction);
        String string = isPString = this.isPWave ? "P" : "S";
        if (!(this.isPWave || this.startBranch != this.tMod.getCmbBranch() && this.endBranch != this.tMod.getCmbBranch())) {
            isPString = "P";
        } else if (this.prevEndAction == PhaseInteraction.KMPS) {
            isPString = "surface wave";
        }
        String branchRange = this.startBranch == this.endBranch ? " layer " + this.startBranch : " layer " + this.startBranch + " to " + this.endBranch;
        String depthRange = this.getDepthRangeString();
        desc = !this.legName.contentEquals("END") ? (String)desc + this.legName + " going " + upDown + " as a " + isPString + " in the " + this.describeBranchRange(this.startBranch, this.endBranch) + "," + branchRange + ", depths " + depthRange + ", then " + action : (String)desc + "END";
        return desc;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDepthRangeString() {
        if (this.isFlat) {
            if (this.prevEndAction == null) {
                return " PrevAction is NULL ";
            }
            if (this.prevEndAction == PhaseInteraction.DIFFRACT) {
                return " at " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + " (DIFF)";
            }
            if (this.prevEndAction == PhaseInteraction.HEAD) {
                return " at " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth() + " (HEAD)";
            }
            if (this.prevEndAction != PhaseInteraction.KMPS) throw new RuntimeException("isFlat but prev not HEAD or DIFFRACT: " + SeismicPhaseSegment.endActionToString(this.prevEndAction));
            return " at surface (KMPS)";
        }
        if (!this.isDownGoing) return this.tMod.getTauBranch(this.startBranch, this.isPWave).getBotDepth() + " to " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth();
        return this.tMod.getTauBranch(this.startBranch, this.isPWave).getTopDepth() + " to " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDepthRangeJSON() {
        if (this.isFlat) {
            if (this.prevEndAction == null) {
                return "\" PrevAction is NULL \"";
            }
            if (this.prevEndAction == PhaseInteraction.DIFFRACT) {
                return "[" + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + "]";
            }
            if (this.prevEndAction == PhaseInteraction.HEAD) {
                return "[" + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth() + "]";
            }
            if (this.prevEndAction != PhaseInteraction.KMPS) throw new RuntimeException("isFlat but prev not HEAD or DIFFRACT: " + SeismicPhaseSegment.endActionToString(this.prevEndAction));
            return "[0]";
        }
        if (!this.isDownGoing) return "[" + this.tMod.getTauBranch(this.startBranch, this.isPWave).getBotDepth() + ", " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth() + "]";
        return "[" + this.tMod.getTauBranch(this.startBranch, this.isPWave).getTopDepth() + ", " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + "]";
    }

    public String getUpDownJSON() {
        String upDown = this.isFlat ? (this.prevEndAction != null ? SeismicPhaseSegment.endActionToString(this.prevEndAction) : "none") : (this.isDownGoing ? "down" : "up");
        return upDown;
    }

    public String toJSONString() {
        Object desc = "";
        if (!this.legName.contentEquals("END")) {
            String isPString;
            String upDown = this.getUpDownJSON();
            String action = SeismicPhaseSegment.endActionToString(this.endAction);
            String string = isPString = this.isPWave ? "P" : "S";
            if (!(this.isPWave || this.startBranch != this.tMod.getCmbBranch() && this.endBranch != this.tMod.getCmbBranch())) {
                isPString = "P";
            } else if (this.prevEndAction == PhaseInteraction.KMPS) {
                isPString = "surface wave";
            }
            String branchRangeJSON = "[" + (this.startBranch == this.endBranch ? " " + this.startBranch : " " + this.startBranch + ", " + this.endBranch) + "]";
            String depthRange = this.getDepthRangeJSON();
            desc = (String)desc + "{\n  \"name\": \"" + this.legName + "\", \"updown\": \"" + upDown + "\", \"type\": \"" + isPString + "\", \"branch_desc\": \"" + this.describeBranchRange(this.startBranch, this.endBranch) + "\", \"branches\": " + branchRangeJSON + ", \"depths\": " + depthRange + ", \"then\": \"" + action + "\"}\n";
        } else {
            desc = (String)desc + "END";
        }
        return desc;
    }

    public List<TimeDist> calcPathTimeDist(Arrival currArrival, TimeDist prevEnd) {
        TimeDist cummulative;
        ArrayList<TimeDist[]> pathList = new ArrayList<TimeDist[]>();
        if (!this.isFlat) {
            int bStep = this.isDownGoing ? 1 : -1;
            for (int i = this.startBranch; this.isDownGoing && i <= this.endBranch || !this.isDownGoing && i >= this.endBranch; i += bStep) {
                int branchNum = i;
                if (ToolRun.DEBUG) {
                    System.out.println("i=" + i + " branchNum=" + branchNum + " isPWave=" + this.isPWave + " downgoing=" + this.isDownGoing);
                }
                try {
                    TimeDist[] tempTimeDist = this.tMod.getTauBranch(branchNum, this.isPWave).path(currArrival.getRayParam(), this.isDownGoing, this.tMod.getSlownessModel());
                    if (tempTimeDist == null) continue;
                    pathList.add(tempTimeDist);
                    continue;
                }
                catch (SlownessModelException e) {
                    throw new RuntimeException("SeismicPhase.calcPath: Caught SlownessModelException. ", e);
                }
            }
        } else {
            double depth;
            TimeDist[] segPath = new TimeDist[2];
            double refractDist = (currArrival.getDist() - currArrival.getPhase().getMinDistance()) * this.flatFractionOfPath;
            double refractTime = refractDist * currArrival.getRayParam();
            TauBranch branch = this.tMod.getTauBranch(this.startBranch, this.isPWave);
            if (this.prevEndAction.equals((Object)PhaseInteraction.DIFFRACT)) {
                depth = branch.getBotDepth();
            } else if (this.prevEndAction.equals((Object)PhaseInteraction.HEAD) || this.prevEndAction.equals((Object)PhaseInteraction.KMPS)) {
                depth = branch.getTopDepth();
            } else {
                throw new RuntimeException("Segment prevEndAction Should be one of KMPS, DIFFRACT or HEAD: " + this.prevEndAction);
            }
            segPath[0] = new TimeDist(currArrival.getRayParam(), 0.0, 0.0, depth);
            segPath[1] = new TimeDist(currArrival.getRayParam(), refractTime, refractDist, depth);
            pathList.add(segPath);
        }
        double prevTime = 0.0;
        double prevDist = 0.0;
        if (prevEnd != null) {
            prevDist = prevEnd.getDistRadian();
            prevTime = prevEnd.getTime();
        }
        ArrayList<TimeDist> outPath = new ArrayList<TimeDist>();
        TimeDist prev = cummulative = new TimeDist(currArrival.getRayParam(), prevTime, prevDist, 0.0);
        int numAdded = 0;
        for (int i = 0; i < pathList.size(); ++i) {
            TimeDist[] branchPath = (TimeDist[])pathList.get(i);
            for (int j = 0; j < branchPath.length; ++j) {
                prev = cummulative;
                cummulative = new TimeDist(cummulative.getP(), cummulative.getTime() + branchPath[j].getTime(), cummulative.getDistRadian() + branchPath[j].getDistRadian(), branchPath[j].getDepth());
                outPath.add(cummulative);
                ++numAdded;
            }
        }
        return outPath;
    }

    public double calcReflTran(Arrival arrival, boolean nextLegIsPWave, boolean allSH) throws VelocityModelException, SlownessModelException {
        double reflTranValue = 1.0;
        VelocityModel vMod = this.getTauModel().getVelocityModel();
        if (!this.isFlat) {
            ReflTrans reflTranCoef;
            int bStep = this.isDownGoing ? 1 : -1;
            for (int i = this.startBranch; this.isDownGoing && i < this.endBranch || !this.isDownGoing && i > this.endBranch; i += bStep) {
                double depth;
                int branchNum = i;
                if (ToolRun.DEBUG) {
                    System.out.println("i=" + i + " branchNum=" + branchNum + " isPWave=" + this.isPWave + " downgoing=" + this.isDownGoing);
                }
                TauBranch tauBranch = this.tMod.getTauBranch(branchNum, this.isPWave);
                if (this.isDownGoing) {
                    depth = tauBranch.getBotDepth();
                    if (arrival.getRayParam() > tauBranch.getMinTurnRayParam()) {
                        continue;
                    }
                } else {
                    depth = tauBranch.getTopDepth();
                    if (arrival.getRayParam() > tauBranch.getMaxRayParam()) continue;
                }
                if (arrival.getSourceDepth() == depth && !this.getTauModel().getVelocityModel().isDisconDepth(depth) || arrival.getReceiverDepth() == depth && !this.getTauModel().getVelocityModel().isDisconDepth(depth) || !this.getTauModel().getVelocityModel().isDisconDepth(depth)) continue;
                reflTranCoef = vMod.calcReflTransCoef(depth, this.isDownGoing);
                double flatRayParam = arrival.getRayParam() / (this.getTauModel().getRadiusOfEarth() - depth);
                if (this.isPWave) {
                    reflTranValue *= reflTranCoef.getTpp(flatRayParam);
                    continue;
                }
                if (allSH) {
                    reflTranValue *= reflTranCoef.getTshsh(flatRayParam);
                    continue;
                }
                reflTranValue *= reflTranCoef.getTss(flatRayParam);
            }
            TauBranch tauBranch = this.tMod.getTauBranch(this.endBranch, this.isPWave);
            double depth = this.isDownGoing ? tauBranch.getBotDepth() : tauBranch.getTopDepth();
            double flatRayParam = arrival.getRayParam() / (this.getTauModel().getRadiusOfEarth() - depth);
            if ((arrival.getSourceDepth() != depth || this.getTauModel().getVelocityModel().isDisconDepth(depth)) && (arrival.getReceiverDepth() != depth || this.getTauModel().getVelocityModel().isDisconDepth(depth))) {
                reflTranCoef = vMod.calcReflTransCoef(depth, this.isDownGoing);
                if (this.endAction == PhaseInteraction.TURN) {
                    if (arrival.getRayParam() < tauBranch.getMinTurnRayParam()) {
                        reflTranValue = this.isPWave ? (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getRpp(flatRayParam)) : (reflTranValue *= reflTranCoef.getRps(flatRayParam))) : (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getRsp(flatRayParam)) : (allSH ? (reflTranValue *= reflTranCoef.getRshsh(flatRayParam)) : (reflTranValue *= reflTranCoef.getRss(flatRayParam))));
                    }
                } else if (this.endAction == PhaseInteraction.TRANSDOWN || this.endAction == PhaseInteraction.TRANSUP) {
                    reflTranValue = this.isPWave ? (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getTpp(flatRayParam)) : (reflTranValue *= reflTranCoef.getTps(flatRayParam))) : (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getTsp(flatRayParam)) : (allSH ? (reflTranValue *= reflTranCoef.getTshsh(flatRayParam)) : (reflTranValue *= reflTranCoef.getTss(flatRayParam))));
                } else if (this.endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL || this.endAction == PhaseInteraction.REFLECT_TOPSIDE || this.endAction == PhaseInteraction.REFLECT_UNDERSIDE) {
                    reflTranValue = this.isPWave ? (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getRpp(flatRayParam)) : (reflTranValue *= reflTranCoef.getRps(flatRayParam))) : (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getRsp(flatRayParam)) : (allSH ? (reflTranValue *= reflTranCoef.getRshsh(flatRayParam)) : (reflTranValue *= reflTranCoef.getRss(flatRayParam))));
                }
            }
            if (Double.isNaN(reflTranValue)) {
                throw new VelocityModelException("Refltran value is NaN: " + reflTranValue + " " + flatRayParam + " " + arrival.getRayParam() + " " + depth + " " + this.isPWave + " " + this.isDownGoing + " " + this.endAction);
            }
        }
        return reflTranValue;
    }
}

