/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Complex;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.VelocityModelException;

public class ReflTransSolidSolid
extends ReflTrans {
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected Complex det;
    protected Complex E;
    protected Complex F;
    protected Complex G;
    protected Complex H;
    protected Complex shDelta;

    public ReflTransSolidSolid(double topVp, double topVs, double topDensity, double botVp, double botVs, double botDensity) throws VelocityModelException {
        super(topVp, topVs, topDensity, botVp, botVs, botDensity);
        if (topVp * topVs * topDensity * botVp * botVs * botDensity == 0.0) {
            throw new VelocityModelException("Solid-solid reflection and transmission coefficients must have non-zero layer params: in:" + topVp + " " + topVs + " " + topDensity + " tr: " + botVp + " " + botVs + " " + botDensity);
        }
    }

    @Override
    public Complex getComplexRpp(double rayParam) throws VelocityModelException {
        this.calcTempVars(rayParam, true);
        Complex FTerm = Complex.times(Complex.minus(Complex.times(this.b, this.topVertSlownessP), Complex.times(this.c, this.botVertSlownessP)), this.F);
        Complex HTerm = Complex.times(Complex.plus(this.a, Complex.times(this.d, Complex.times(this.topVertSlownessP, this.botVertSlownessS))), Complex.times(this.H, this.sqRP));
        Complex out = Complex.over(Complex.minus(FTerm, HTerm), this.det);
        return out;
    }

    @Override
    public Complex getComplexRps(double rayParam) {
        this.calcTempVars(rayParam, true);
        double realNumerator = -2.0 * this.rp * (this.topVp / this.topVs);
        Complex middleTerm = Complex.plus(this.a * this.b, Complex.times(this.c * this.d, Complex.times(this.botVertSlownessP, this.botVertSlownessS)));
        Complex numerator = Complex.times(Complex.times(realNumerator, this.topVertSlownessP), middleTerm);
        return Complex.over(numerator, this.det);
    }

    @Override
    public Complex getComplexTpp(double rayParam) {
        this.calcTempVars(rayParam, true);
        double realNumerator = 2.0 * this.topDensity * (this.topVp / this.botVp);
        return Complex.over(Complex.times(realNumerator, Complex.times(this.topVertSlownessP, this.F)), this.det);
    }

    @Override
    public Complex getComplexTps(double rayParam) {
        this.calcTempVars(rayParam, true);
        double realNumerator = 2.0 * this.topDensity * this.rp * (this.topVp / this.botVs);
        Complex numerator = Complex.times(realNumerator, Complex.times(this.topVertSlownessP, this.H));
        return Complex.over(numerator, this.det);
    }

    @Override
    public Complex getComplexRsp(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = -2.0 * this.rp * (this.topVs / this.topVp);
        Complex middleTerm = Complex.plus(this.a * this.b, Complex.times(this.c * this.d, Complex.times(this.botVertSlownessP, this.botVertSlownessS)));
        Complex numerator = Complex.times(realNumerator, Complex.times(this.topVertSlownessS, middleTerm));
        return Complex.over(numerator, this.det);
    }

    @Override
    public Complex getComplexRss(double rayParam) {
        this.calcTempVars(rayParam, false);
        Complex adNumerator = Complex.times(Complex.plus(this.a, Complex.times(this.d, Complex.times(this.botVertSlownessP, this.topVertSlownessS))), Complex.times(this.G, this.sqRP));
        Complex bcNumerator = Complex.times(Complex.minus(Complex.times(this.b, this.topVertSlownessS), Complex.times(this.c, this.botVertSlownessS)), this.E);
        return Complex.over(Complex.minus(adNumerator, bcNumerator), this.det);
    }

    @Override
    public Complex getComplexTsp(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = -2.0 * this.topDensity * this.rp * (this.topVs / this.botVp);
        Complex numerator = Complex.times(realNumerator, Complex.times(this.topVertSlownessS, this.G));
        return Complex.over(numerator, this.det);
    }

    @Override
    public Complex getComplexTss(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = 2.0 * this.topDensity * (this.topVs / this.botVs);
        Complex numerator = Complex.times(realNumerator, Complex.times(this.topVertSlownessS, this.E));
        return Complex.over(numerator, this.det);
    }

    @Override
    public Complex getComplexRshsh(double rayParam) {
        this.calcTempVars(rayParam, false);
        double topMu = this.topVs * this.topVs * this.topDensity;
        double botMu = this.botVs * this.botVs * this.botDensity;
        Complex topTerm = Complex.times(topMu, this.topVertSlownessS);
        Complex botTerm = Complex.times(botMu, this.botVertSlownessS);
        return Complex.over(Complex.minus(topTerm, botTerm), Complex.plus(topTerm, botTerm));
    }

    @Override
    public Complex getComplexTshsh(double rayParam) {
        this.calcTempVars(rayParam, false);
        double topMu = this.topVs * this.topVs * this.topDensity;
        double botMu = this.botVs * this.botVs * this.botDensity;
        Complex topTerm = Complex.times(topMu, this.topVertSlownessS);
        Complex botTerm = Complex.times(botMu, this.botVertSlownessS);
        return Complex.over(Complex.times(topTerm, 2.0), Complex.plus(topTerm, botTerm));
    }

    @Override
    public ReflTransSolidSolid flip() throws VelocityModelException {
        return new ReflTransSolidSolid(this.botVp, this.botVs, this.botDensity, this.topVp, this.topVs, this.topDensity);
    }

    protected Object clone() throws CloneNotSupportedException {
        try {
            return new ReflTransSolidSolid(this.topVp, this.topVs, this.topDensity, this.botVp, this.botVs, this.sqBotVs);
        }
        catch (VelocityModelException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    public String toString() {
        return "Solid-solid:  in:" + this.topVp + " " + this.topVs + " " + this.topDensity + " tr: " + this.botVp + " " + this.botVs + " " + this.botDensity;
    }

    public Complex[][] calcScatterMatrix(double rayParam) throws VelocityModelException {
        ReflTransSolidSolid flip = this.flip();
        Complex[][] out = new Complex[4][4];
        out[0] = new Complex[]{this.getComplexRpp(rayParam), this.getComplexRsp(rayParam), ((ReflTrans)flip).getComplexTpp(rayParam), ((ReflTrans)flip).getComplexTsp(rayParam)};
        out[1] = new Complex[]{this.getComplexRps(rayParam), this.getComplexRss(rayParam), ((ReflTrans)flip).getComplexTps(rayParam), ((ReflTrans)flip).getComplexTss(rayParam)};
        out[2] = new Complex[]{this.getComplexTpp(rayParam), this.getComplexTsp(rayParam), ((ReflTrans)flip).getComplexRpp(rayParam), ((ReflTrans)flip).getComplexRsp(rayParam)};
        out[3] = new Complex[]{this.getComplexTps(rayParam), this.getComplexTss(rayParam), ((ReflTrans)flip).getComplexRps(rayParam), ((ReflTrans)flip).getComplexRss(rayParam)};
        return out;
    }

    public Complex[][] calcSqrtEnergyFluxMatrix(double rayParam) throws VelocityModelException {
        Complex[][] out = this.calcScatterMatrix(rayParam);
        double cos_p_top = this.topDensity * this.topVp * Math.sqrt(1.0 - this.sqRP * this.sqTopVp);
        double cos_s_top = this.topDensity * this.topVs * Math.sqrt(1.0 - this.sqRP * this.sqTopVs);
        double cos_p_bot = this.botDensity * this.botVp * Math.sqrt(1.0 - this.sqRP * this.sqBotVp);
        double cos_s_bot = this.botDensity * this.botVs * Math.sqrt(1.0 - this.sqRP * this.sqBotVs);
        out[0][1] = out[0][1].times(Math.sqrt(cos_p_top / cos_s_top));
        out[0][2] = out[0][2].times(Math.sqrt(cos_p_top / cos_p_bot));
        out[0][3] = out[0][3].times(Math.sqrt(cos_p_top / cos_s_bot));
        out[1][0] = out[1][0].times(Math.sqrt(cos_s_top / cos_p_top));
        out[1][2] = out[1][2].times(Math.sqrt(cos_s_top / cos_p_bot));
        out[1][3] = out[1][3].times(Math.sqrt(cos_s_top / cos_s_bot));
        out[2][0] = out[2][0].times(Math.sqrt(cos_p_bot / cos_p_top));
        out[2][1] = out[2][1].times(Math.sqrt(cos_p_bot / cos_s_top));
        out[2][3] = out[2][3].times(Math.sqrt(cos_p_bot / cos_s_bot));
        out[3][0] = out[3][0].times(Math.sqrt(cos_s_bot / cos_p_top));
        out[3][1] = out[3][1].times(Math.sqrt(cos_s_bot / cos_s_top));
        out[3][2] = out[3][2].times(Math.sqrt(cos_s_bot / cos_p_bot));
        return out;
    }

    protected void calcTempVars(double rayParam, boolean inIsPWave) {
        if (rayParam < 0.0) {
            throw new IllegalArgumentException("rayParam cannot be negative");
        }
        this.rp = rayParam;
        if (rayParam != this.lastRayParam || inIsPWave != this.lastInIsPWave) {
            this.lastRayParam = -1.0;
            this.sqRP = this.rp * this.rp;
            this.topVertSlownessP = this.calcInVerticalSlownessP(this.rp);
            this.topVertSlownessS = this.calcInVerticalSlownessS(this.rp);
            this.botVertSlownessP = this.calcTransVerticalSlownessP(this.rp);
            this.botVertSlownessS = this.calcTransVerticalSlownessS(this.rp);
            this.a = this.botDensity * (1.0 - 2.0 * this.sqBotVs * this.sqRP) - this.topDensity * (1.0 - 2.0 * this.sqTopVs * this.sqRP);
            this.b = this.botDensity * (1.0 - 2.0 * this.sqBotVs * this.sqRP) + 2.0 * this.topDensity * this.sqTopVs * this.sqRP;
            this.c = this.topDensity * (1.0 - 2.0 * this.sqTopVs * this.sqRP) + 2.0 * this.botDensity * this.sqBotVs * this.sqRP;
            this.d = 2.0 * (this.botDensity * this.sqBotVs - this.topDensity * this.sqTopVs);
            this.E = Complex.plus(this.topVertSlownessP.times(this.b), this.botVertSlownessP.times(this.c));
            this.F = Complex.plus(this.topVertSlownessS.times(this.b), this.botVertSlownessS.times(this.c));
            this.G = Complex.minus(new Complex(this.a), Complex.times(this.d, Complex.times(this.topVertSlownessP, this.botVertSlownessS)));
            this.H = Complex.minus(new Complex(this.a), Complex.times(this.d, Complex.times(this.botVertSlownessP, this.topVertSlownessS)));
            this.det = Complex.plus(Complex.times(this.E, this.F), Complex.times(this.G, this.H).times(this.sqRP));
            this.shDelta = Complex.plus(Complex.plus(this.topDensity * this.topVs * this.topVs, this.topVertSlownessS), Complex.plus(this.botDensity * this.botVs * this.botVs, this.botVertSlownessS));
            this.lastRayParam = rayParam;
            this.lastInIsPWave = inIsPWave;
        }
    }
}

