/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Complex;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.VelocityModelException;

public class ReflTransSolidFluid
extends ReflTrans {
    Complex DSolidFluid;

    public ReflTransSolidFluid(double topVp, double topVs, double topDensity, double botVp, double botDensity) throws VelocityModelException {
        super(topVp, topVs, topDensity, botVp, 0.0, botDensity);
        if (topVp * topVs * topDensity * botVp * botDensity == 0.0) {
            throw new VelocityModelException("Solid-fluid reflection and transmission coefficients must have non-zero layer params: in:" + topVp + " " + topVs + " " + topDensity + " tr: " + botVp + " " + botDensity);
        }
    }

    @Override
    public Complex getComplexRpp(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex a1Term = this.topVertSlownessP.times(this.botVertSlownessP.times(this.topVertSlownessS).times(4.0 * this.sqTopVs * this.sqTopVs * this.sqRP * this.topDensity).plus(this.botDensity));
        Complex a2Term = this.botVertSlownessP.times(this.topDensity).times((1.0 - 2.0 * this.sqTopVs * this.sqRP) * (1.0 - 2.0 * this.sqTopVs * this.sqRP));
        Complex out = Complex.over(Complex.minus(a1Term, a2Term), this.DSolidFluid);
        return out;
    }

    @Override
    public Complex getComplexRps(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex numeratorTerm = Complex.times(this.topVertSlownessP, this.botVertSlownessP).times(4.0 * this.topVp * this.topVs * this.rp * this.topDensity).times(2.0 * this.sqTopVs * this.sqRP - 1.0);
        Complex out = Complex.over(numeratorTerm, this.DSolidFluid);
        return out;
    }

    @Override
    public Complex getComplexTpp(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex numeratorTerm = this.topVertSlownessP.times(2.0 * (this.topVp / this.botVp) * this.topDensity).times(1.0 - 2.0 * this.sqTopVs * this.sqRP);
        Complex out = Complex.over(numeratorTerm, this.DSolidFluid);
        return out;
    }

    @Override
    public Complex getComplexRss(double rayParam) throws VelocityModelException {
        this.calcTempVars(rayParam, false);
        Complex a2Term = Complex.times(this.botVertSlownessP, this.topDensity * (1.0 - 2.0 * this.sqTopVs * this.sqRP) * (1.0 - 2.0 * this.sqTopVs * this.sqRP));
        Complex a1Term = Complex.times(this.topVertSlownessP, Complex.minus(this.botDensity, Complex.times(this.botVertSlownessP, this.topVertSlownessS).times(4.0 * this.sqTopVs * this.sqTopVs * this.sqRP * this.topDensity)));
        Complex out = Complex.over(Complex.plus(a2Term, a1Term), this.DSolidFluid);
        return out;
    }

    @Override
    public Complex getComplexRsp(double rayParam) throws VelocityModelException {
        this.calcTempVars(rayParam, false);
        Complex numeratorTerm = Complex.times(this.botVertSlownessP, this.topVertSlownessS).times(4.0 / this.topVp * this.sqTopVs * this.topVs * this.rp * this.topDensity * (1.0 - 2.0 * this.sqTopVs * this.sqRP));
        Complex out = Complex.over(numeratorTerm, this.DSolidFluid);
        return out;
    }

    @Override
    public Complex getComplexTsp(double rayParam) throws VelocityModelException {
        this.calcTempVars(rayParam, false);
        Complex numeratorTerm = Complex.times(this.topVertSlownessP, this.topVertSlownessS).times(4.0 / this.botVp * this.sqTopVs * this.topVs * this.topDensity * this.rp);
        Complex out = Complex.over(numeratorTerm, this.DSolidFluid);
        return out;
    }

    @Override
    public Complex getComplexRshsh(double rayParam) throws VelocityModelException {
        return new Complex(1.0);
    }

    @Override
    public Complex getComplexTps(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for solid to fluid");
    }

    @Override
    public Complex getComplexTss(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for solid to fluid");
    }

    @Override
    public Complex getComplexTshsh(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for solid to fluid");
    }

    @Override
    public ReflTrans flip() throws VelocityModelException {
        return null;
    }

    public String toString() {
        return "Solid-fluid:  in: Vp: " + this.topVp + " Vs: " + this.topVs + " d: " + this.topDensity + " tr: Vp" + this.botVp + " d: " + this.botDensity;
    }

    protected void calcTempVars(double rayParam, boolean inIsPWave) {
        if (rayParam < 0.0) {
            throw new IllegalArgumentException("rayParam cannot be negative");
        }
        this.rp = rayParam;
        if (rayParam != this.lastRayParam || inIsPWave != this.lastInIsPWave) {
            this.lastRayParam = -1.0;
            this.sqRP = this.rp * this.rp;
            this.topVertSlownessP = this.calcInVerticalSlownessP(this.rp);
            this.topVertSlownessS = this.calcInVerticalSlownessS(this.rp);
            this.botVertSlownessP = this.calcTransVerticalSlownessP(this.rp);
            this.botVertSlownessS = this.calcTransVerticalSlownessP(this.rp);
            Complex dsfBracketTerm = Complex.plus(this.topVertSlownessP.times(this.topVertSlownessS).times(4.0 * this.sqTopVs * this.sqTopVs * this.sqRP), (1.0 - 2.0 * this.sqTopVs * this.sqRP) * (1.0 - 2.0 * this.sqTopVs * this.sqRP));
            this.DSolidFluid = Complex.plus(this.topVertSlownessP.times(this.botDensity), this.botVertSlownessP.times(this.topDensity).times(dsfBracketTerm));
            this.lastRayParam = rayParam;
            this.lastInIsPWave = inIsPWave;
        }
    }
}

