/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Complex;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.ReflTransSolidFluid;
import edu.sc.seis.TauP.VelocityModelException;

public class ReflTransFluidSolid
extends ReflTrans {
    Complex DFluidSolid;
    double cos2fterm;

    public ReflTransFluidSolid(double topVp, double topDensity, double botVp, double botVs, double botDensity) throws VelocityModelException {
        super(topVp, 0.0, topDensity, botVp, botVs, botDensity);
        if (topVp * topDensity * botVp * botVs * botDensity == 0.0) {
            throw new VelocityModelException("Fluid-solid reflection and transmission coefficients must have non-zero layer params: in:" + topVp + " " + topDensity + " tr: " + botVp + " " + botVs + " " + botDensity);
        }
    }

    @Override
    public Complex getComplexRpp(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex t1 = this.botVertSlownessP.times(this.botVertSlownessS).times(4.0 * this.sqBotVs * this.sqBotVs * this.sqRP).plus(this.cos2fterm * this.cos2fterm);
        Complex parenA = this.topVertSlownessP.times(this.botDensity).times(t1).times(-1.0);
        Complex parenB = this.botVertSlownessP.times(this.topDensity).times(2.0 * this.sqBotVs * this.sqRP + this.cos2fterm);
        Complex out = parenA.plus(parenB).times(this.sqBotVp / (this.botVs * this.topDensity));
        return out.over(this.DFluidSolid);
    }

    @Override
    public Complex getComplexTpp(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex out = this.topVertSlownessP.times(-2.0 * this.topVp * this.botVp * this.cos2fterm / this.botVs);
        return out.over(this.DFluidSolid);
    }

    @Override
    public Complex getComplexTps(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex out = this.topVertSlownessP.times(this.botVertSlownessP).times(4.0 * this.topVp * this.sqBotVp * this.rp);
        return out.over(this.DFluidSolid);
    }

    @Override
    public Complex getComplexRps(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to solid");
    }

    @Override
    public Complex getComplexRsp(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to solid");
    }

    @Override
    public Complex getComplexRss(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to solid");
    }

    @Override
    public Complex getComplexTsp(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to solid");
    }

    @Override
    public Complex getComplexTss(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to solid");
    }

    @Override
    public Complex getComplexRshsh(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to solid");
    }

    @Override
    public Complex getComplexTshsh(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to solid");
    }

    @Override
    public ReflTrans flip() throws VelocityModelException {
        return new ReflTransSolidFluid(this.botVp, this.botVs, this.botDensity, this.topVp, this.topDensity);
    }

    public String toString() {
        return "Fluid-solid:  in: Vp: " + this.topVp + " d: " + this.topDensity + " tr: Vp" + this.botVp + " Vs: " + this.botVs + " d: " + this.botDensity;
    }

    protected void calcTempVars(double rayParam, boolean inIsPWave) {
        if (rayParam < 0.0) {
            throw new IllegalArgumentException("rayParam cannot be negative");
        }
        this.rp = rayParam;
        if (rayParam != this.lastRayParam || inIsPWave != this.lastInIsPWave) {
            this.lastRayParam = -1.0;
            this.sqRP = this.rp * this.rp;
            this.topVertSlownessP = this.calcInVerticalSlownessP(this.rp);
            this.botVertSlownessP = this.calcTransVerticalSlownessP(this.rp);
            this.botVertSlownessS = this.calcTransVerticalSlownessS(this.rp);
            this.cos2fterm = 1.0 - 2.0 * this.sqBotVs * this.sqRP;
            Complex t1 = this.topVertSlownessP.times(this.botVertSlownessP).times(this.botVertSlownessS).times(4.0 * this.sqBotVs * this.sqBotVs * this.sqRP * this.botDensity);
            Complex t2 = this.topVertSlownessP.times(this.botDensity * this.cos2fterm * this.cos2fterm);
            Complex t3 = this.botVertSlownessP.times(2.0 * this.sqBotVs * this.sqRP * this.topDensity);
            Complex t4 = this.botVertSlownessP.times(this.topDensity * this.cos2fterm);
            Complex paren = t1.plus(t2).plus(t3).plus(t4);
            this.DFluidSolid = paren.times(-1.0 * this.sqBotVp / (this.botVs * this.topDensity));
            this.lastRayParam = rayParam;
            this.lastInIsPWave = inIsPWave;
        }
    }
}

