/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Complex;
import edu.sc.seis.TauP.VelocityModelException;

public abstract class ReflTrans {
    protected double topVp;
    protected double topVs;
    protected double topDensity;
    protected double botVp;
    protected double botVs;
    protected double botDensity;
    protected double rp;
    protected Complex topVertSlownessP;
    protected Complex topVertSlownessS;
    protected Complex botVertSlownessP;
    protected Complex botVertSlownessS;
    protected double sqBotVs;
    protected double sqTopVs;
    protected double sqBotVp;
    protected double sqTopVp;
    protected double sqRP;
    protected double lastRayParam = -1.0;
    protected boolean lastInIsPWave = true;
    protected static final Complex CX = new Complex();

    public ReflTrans(double topVp, double topVs, double topDensity, double botVp, double botVs, double botDensity) {
        this.topVp = topVp;
        this.topVs = topVs;
        this.topDensity = topDensity;
        this.botVp = botVp;
        this.botVs = botVs;
        this.botDensity = botDensity;
        this.sqBotVs = botVs * botVs;
        this.sqTopVs = topVs * topVs;
        this.sqBotVp = botVp * botVp;
        this.sqTopVp = topVp * topVp;
    }

    public abstract Complex getComplexRpp(double var1) throws VelocityModelException;

    public abstract Complex getComplexRps(double var1) throws VelocityModelException;

    public abstract Complex getComplexTpp(double var1) throws VelocityModelException;

    public abstract Complex getComplexTps(double var1) throws VelocityModelException;

    public abstract Complex getComplexRsp(double var1) throws VelocityModelException;

    public abstract Complex getComplexRss(double var1) throws VelocityModelException;

    public abstract Complex getComplexTsp(double var1) throws VelocityModelException;

    public abstract Complex getComplexTss(double var1) throws VelocityModelException;

    public abstract Complex getComplexRshsh(double var1) throws VelocityModelException;

    public abstract Complex getComplexTshsh(double var1) throws VelocityModelException;

    public abstract ReflTrans flip() throws VelocityModelException;

    public double getRpp(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRpp(rayParam));
    }

    public double getRps(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRps(rayParam));
    }

    public double getTpp(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTpp(rayParam));
    }

    public double getTps(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTps(rayParam));
    }

    public double getRsp(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRsp(rayParam));
    }

    public double getRss(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRss(rayParam));
    }

    public double getTsp(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTsp(rayParam));
    }

    public double getTss(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTss(rayParam));
    }

    public double getRshsh(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRshsh(rayParam));
    }

    public double getTshsh(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTshsh(rayParam));
    }

    public static double getRealCoefficient(Complex coef) {
        if (Math.abs(coef.im) > 1.0E-6) {
            return Complex.abs(coef);
        }
        return coef.re;
    }

    public Complex calcInVerticalSlownessP(double flatRP) {
        return Complex.sqrt(new Complex(1.0 / this.sqTopVp - flatRP * flatRP));
    }

    public Complex calcInVerticalSlownessS(double flatRP) {
        return Complex.sqrt(new Complex(1.0 / this.sqTopVs - flatRP * flatRP));
    }

    public Complex calcTransVerticalSlownessP(double flatRP) {
        return Complex.sqrt(new Complex(1.0 / this.sqBotVp - flatRP * flatRP));
    }

    public Complex calcTransVerticalSlownessS(double flatRP) {
        return Complex.sqrt(new Complex(1.0 / this.sqBotVs - flatRP * flatRP));
    }

    public double[] calcCriticalRayParams() {
        double[] criticalSlownesses = new double[]{1.0 / this.topVp, 1.0 / this.botVp, 1.0 / this.topVs, 1.0 / this.botVs};
        return criticalSlownesses;
    }
}

