/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LegPuller;
import edu.sc.seis.TauP.TauModelException;
import java.io.Serializable;
import java.util.ArrayList;

public class PhaseName
implements Serializable {
    public String name;
    public int sacTNum = -1;
    public ArrayList<Integer> sacTNumTriplication = new ArrayList();

    public PhaseName(String name) throws TauModelException {
        this.name = name;
        LegPuller.legPuller(name);
    }

    public PhaseName(String name, int sacTNum) throws TauModelException {
        this(name);
        this.sacTNum = sacTNum;
        this.sacTNumTriplication.add(sacTNum);
    }

    public PhaseName(String name, String sacTNumList) throws TauModelException {
        this(name);
        this.parseSacTNums(sacTNumList);
    }

    void parseSacTNums(String sacTNumList) throws TauModelException {
        for (int j = 0; j < sacTNumList.length(); ++j) {
            int intForChar;
            char c = sacTNumList.charAt(j);
            if (Character.isDigit(c)) {
                intForChar = Integer.parseInt("" + c);
            } else if (c == 'a') {
                intForChar = 10;
            } else if (c == 'x') {
                intForChar = 11;
            } else {
                throw new TauModelException("Problem with phase=" + this.name + ", unknown SAC header TNum: " + c);
            }
            if (this.sacTNumTriplication.contains(intForChar)) {
                throw new TauModelException("SAC TNum is duplicated for phase " + this.name + ", in " + sacTNumList);
            }
            this.sacTNumTriplication.add(intForChar);
        }
        if (this.sacTNumTriplication.size() > 0) {
            this.sacTNum = this.sacTNumTriplication.get(0);
        }
    }

    public boolean equals(PhaseName obj) {
        return obj.name.equals(this.name) && obj.sacTNum == this.sacTNum;
    }

    public String getName() {
        return this.name;
    }

    public int sacTNumForTriplication(int index) {
        return this.sacTNumTriplication.get(index);
    }

    public String toString() {
        return this.name;
    }
}

