/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed3;

import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.FDSNSourceIdException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.json.JSONObject;

public class MSeed3Record {
    public static final String TIME_LEAP_SECOND = "TimeLeapSecond";
    public static final int UNKNOWN_DATA_VERSION = 0;
    protected String recordIndicator = "MS";
    protected byte formatVersion = (byte)3;
    protected byte flags = 0;
    protected int year = 1970;
    protected int dayOfYear = 1;
    protected int hour = 0;
    protected int minute = 0;
    protected int second = 0;
    protected int nanosecond = 0;
    protected double sampleRatePeriod = 1.0;
    protected double sampleRate = 1.0;
    protected byte timeseriesEncodingFormat;
    protected byte publicationVersion = 0;
    protected int numSamples = 0;
    protected int recordCRC = 0;
    protected byte sourceIdByteLength = 0;
    protected int extraHeadersByteLength = 0;
    protected int dataByteLength = 0;
    protected String sourceIdStr = "";
    protected FDSNSourceId sourceId;
    protected String extraHeadersStr = "";
    protected JSONObject extraHeaders;
    protected byte[] timeseriesBytes = new byte[0];
    public static final ZoneId TZ_UTC = ZoneId.of("UTC");
    public static final String ZULU = "Z";
    public static final String FDSN_PREFIX = "FDSN:";
    public static final int NETWORK_CODE_LENGTH = 8;
    public static final int STATION_CODE_LENGTH = 8;
    public static final int LOCATION_CODE_LENGTH = 8;
    public static final int CHANNEL_CODE_LENGTH = 4;
    public static final int FIXED_HEADER_SIZE = 40;
    protected static final String DEFAULT_RECORD_INDICATOR = "MS";
    protected static final byte DEFAULT_MINISEED_VERSION = 3;
    public static final long SEC_NANOS = 1000000000L;
    public static final long DAY_NANOS = 86400000000000L;
    public static final long LAST_SEC_NANOS = 86399000000000L;

    public void printASCII(PrintWriter out) throws IOException {
        this.printASCII(out, "");
    }

    public void printASCII(PrintWriter out, String indent) throws IOException {
        this.printASCII(out, indent, false);
    }

    public void printASCII(PrintWriter out, String indent, boolean withData) throws IOException {
        out.format(indent + "%s, version %d, %d bytes (format: %d)%n", this.getSourceId(), this.getPublicationVersion(), this.getSize(), this.getFormatVersion());
        out.println(indent + "             start time: " + this.getStartTimeString());
        out.println(indent + "      number of samples: " + this.getNumSamples());
        String srateStr = String.format("%.10g", this.getSampleRate());
        while (srateStr.endsWith("00")) {
            srateStr = srateStr.substring(0, srateStr.length() - 1);
        }
        out.format(indent + "       sample rate (Hz): %s%n", srateStr);
        byte b = this.getFlags();
        out.format(indent + "                  flags: [%d%d%d%d%d%d%d%d] 8 bits%n", (b & 0x80) >> 7, (b & 0x40) >> 6, (b & 0x20) >> 5, (b & 0x10) >> 4, (b & 8) >> 3, (b & 4) >> 2, (b & 2) >> 1, b & 1);
        if ((b & 1) != 0) {
            out.println(indent + "                         [Bit 0] Calibration signals present");
        }
        if ((b & 2) != 0) {
            out.println(indent + "                         [Bit 1] Time tag is questionable");
        }
        if ((b & 4) != 0) {
            out.println(indent + "                         [Bit 2] Clock locked");
        }
        if ((b & 8) != 0) {
            out.println(indent + "                         [Bit 3] Undefined bit set");
        }
        if ((b & 0x10) != 0) {
            out.println(indent + "                         [Bit 4] Undefined bit set");
        }
        if ((b & 0x20) != 0) {
            out.println(indent + "                         [Bit 5] Undefined bit set");
        }
        if ((b & 0x40) != 0) {
            out.println(indent + "                         [Bit 6] Undefined bit set");
        }
        if ((b & 0x80) != 0) {
            out.println(indent + "                         [Bit 7] Undefined bit set");
        }
        out.format(indent + "                    CRC: 0x%8X%n", this.getRecordCRC());
        out.format(indent + "    extra header length: %d bytes%n", this.getExtraHeadersByteLength());
        out.format(indent + "    data payload length: %d bytes%n", this.getDataByteLength());
        out.format(indent + "       payload encoding: %s (val: %d)%n", this.getTimeseriesEncodingFormatName(), this.getTimeseriesEncodingFormat());
        if (this.getExtraHeaders() != null && !this.getExtraHeaders().isEmpty()) {
            String[] ehLines;
            out.println(indent + "          extra headers:");
            for (String line : ehLines = this.getExtraHeadersAsString(2).split("\n")) {
                out.println("          " + line);
            }
        }
        if (withData) {
            out.println(indent + "Data:");
            this.printDataASCII(out, indent);
        }
    }

    public void printDataASCII(PrintWriter out) {
        this.printDataASCII(out, "");
    }

    public void printDataASCII(PrintWriter out, String indent) {
        try {
            DecompressedData decomp = this.decompress();
            if (decomp.getType() == 3) {
                int[] data = decomp.getAsInt();
                MSeed3Record.printData(out, indent, data);
            } else if (decomp.getType() == 1) {
                short[] data = decomp.getAsShort();
                MSeed3Record.printData(out, indent, data);
            } else if (decomp.getType() == 4) {
                float[] data = decomp.getAsFloat();
                MSeed3Record.printData(out, indent, data);
            } else if (decomp.getType() == 5) {
                double[] data = decomp.getAsDouble();
                MSeed3Record.printData(out, indent, data);
            } else {
                out.println("Unknown data compression: " + decomp.getType());
            }
        }
        catch (Exception e) {
            out.println("Unable to decompress: " + this.getTimeseriesEncodingFormat());
            out.println(e);
        }
    }

    public static void printData(PrintWriter out, String indent, int[] data) {
        int cols = 6;
        int i = 0;
        for (i = 0; i < data.length; ++i) {
            if (i % cols == 0) {
                out.write(indent);
            }
            out.format("%10d", data[i]);
            if (i % cols != cols - 1 || i == 0) continue;
            out.write("\n");
        }
        if (i % cols != cols - 1 && i != 0) {
            out.write("\n");
        }
    }

    public static void printData(PrintWriter out, String indent, short[] data) {
        int cols = 6;
        int i = 0;
        for (i = 0; i < data.length; ++i) {
            if (i % cols == 0) {
                out.write(indent);
            }
            out.format("%10d ", data[i]);
            if (i % cols != cols - 1 || i == 0) continue;
            out.write("\n");
        }
        if (i % cols != cols - 1 && i != 0) {
            out.write("\n");
        }
    }

    public static void printData(PrintWriter out, String indent, float[] data) {
        int cols = 6;
        int i = 0;
        for (i = 0; i < data.length; ++i) {
            if (i % cols == 0) {
                out.write(indent);
            }
            out.format("%10.8g  ", Float.valueOf(data[i]));
            if (i % cols != cols - 1 || i == 0) continue;
            out.write("\n");
        }
        if (i % cols != cols - 1 && i != 0) {
            out.write("\n");
        }
    }

    public static void printData(PrintWriter out, String indent, double[] data) {
        int cols = 6;
        int i = 0;
        for (i = 0; i < data.length; ++i) {
            if (i % cols == 0) {
                out.write(indent);
            }
            out.format("%12.10g  ", data[i]);
            if (i % cols != cols - 1 || i == 0) continue;
            out.write("\n");
        }
        if (i % cols != cols - 1 && i != 0) {
            out.write("\n");
        }
    }

    public void printDataRawBytes(PrintWriter out, String indent) {
        byte[] d = this.getTimeseriesBytes();
        DecimalFormat byteFormat = new DecimalFormat("000");
        for (int i = 0; i < d.length; ++i) {
            if (i % 16 == 0) {
                out.write(indent);
            }
            out.write(byteFormat.format(0xFF & d[i]) + " ");
            if (i % 4 == 3) {
                out.write("  ");
            }
            if (i % 16 != 15 || i == 0) continue;
            out.write("\n");
        }
    }

    public static MSeed3Record read(DataInput in) throws IOException, SeedFormatException, FDSNSourceIdException {
        byte[] buf = new byte[40];
        in.readFully(buf);
        MSeed3Record header = new MSeed3Record();
        header.read(buf, 0);
        buf = new byte[header.sourceIdByteLength];
        in.readFully(buf);
        String sourceIdStr = new String(buf, 0, (int)header.sourceIdByteLength).trim();
        if (sourceIdStr.startsWith(FDSN_PREFIX)) {
            FDSNSourceId sid;
            header.sourceId = sid = FDSNSourceId.parse(sourceIdStr);
        } else {
            header.sourceIdStr = sourceIdStr;
            header.sourceId = null;
        }
        buf = new byte[header.extraHeadersByteLength];
        in.readFully(buf);
        header.extraHeadersStr = new String(buf, 0, header.extraHeadersByteLength).trim();
        header.timeseriesBytes = new byte[header.dataByteLength];
        in.readFully(header.timeseriesBytes);
        return header;
    }

    protected int read(byte[] buf, int offset) {
        this.recordIndicator = new String(buf, offset, 2);
        this.formatVersion = buf[offset += 2];
        this.flags = buf[++offset];
        this.nanosecond = Utility.bytesToInt(buf[++offset], buf[offset + 1], buf[offset + 2], buf[offset + 3], true);
        this.year = Utility.bytesToInt(buf[offset += 4], buf[offset + 1], true);
        this.dayOfYear = Utility.bytesToInt(buf[offset += 2], buf[offset + 1], true);
        this.hour = buf[offset += 2];
        this.minute = buf[++offset];
        this.second = buf[++offset];
        this.timeseriesEncodingFormat = buf[++offset];
        this.sampleRatePeriod = Utility.bytesToDouble(buf, ++offset, true);
        this.sampleRate = this.sampleRatePeriod < 0.0 ? -1.0 / this.sampleRatePeriod : this.sampleRatePeriod;
        this.numSamples = Utility.bytesToInt(buf[offset += 8], buf[offset + 1], buf[offset + 2], buf[offset + 3], true);
        this.recordCRC = Utility.bytesToInt(buf[offset += 4], buf[offset + 1], buf[offset + 2], buf[offset + 3], true);
        this.publicationVersion = buf[offset += 4];
        this.sourceIdByteLength = buf[++offset];
        this.extraHeadersByteLength = Utility.bytesToInt(buf[++offset], buf[offset + 1], true);
        this.dataByteLength = Utility.bytesToInt(buf[offset += 2], buf[offset + 1], buf[offset + 2], buf[offset + 3], true);
        return offset += 4;
    }

    public void write(OutputStream dos) throws IOException {
        dos.write(this.recordIndicator.getBytes("ASCII"));
        dos.write(this.formatVersion);
        dos.write(this.flags);
        dos.write(Utility.shortToLittleEndianByteArray(this.year));
        dos.write(Utility.shortToLittleEndianByteArray(this.dayOfYear));
        dos.write(this.hour);
        dos.write(this.minute);
        dos.write(this.second);
        dos.write(Utility.intToLittleEndianByteArray(this.nanosecond));
        dos.write(Utility.doubleToLittleEndianByteArray(this.sampleRatePeriod));
        dos.write(this.timeseriesEncodingFormat);
        dos.write(this.publicationVersion);
        dos.write(Utility.intToLittleEndianByteArray(this.numSamples));
        dos.write(Utility.intToLittleEndianByteArray(this.recordCRC));
        byte[] sourceIdBytes = this.sourceId.toString().getBytes();
        dos.write((byte)sourceIdBytes.length);
        byte[] extraHeadersBytes = this.getExtraHeadersAsString(0).getBytes();
        this.extraHeadersByteLength = extraHeadersBytes.length;
        dos.write(Utility.shortToLittleEndianByteArray(extraHeadersBytes.length));
        dos.write(Utility.shortToLittleEndianByteArray(this.timeseriesBytes.length));
        dos.write(sourceIdBytes);
        dos.write(extraHeadersBytes);
        dos.write(this.timeseriesBytes);
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            this.write(byteStream);
            byteStream.close();
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException, should not happen.", e);
        }
    }

    public int getLeapSecInRecord() {
        if (this.getExtraHeaders().has(TIME_LEAP_SECOND)) {
            return this.getExtraHeaders().getInt(TIME_LEAP_SECOND);
        }
        return 0;
    }

    public void setLeapSecInRecord(int value) {
        JSONObject eh = this.getExtraHeaders();
        eh.put(TIME_LEAP_SECOND, value);
    }

    public void setStartDateTime(ZonedDateTime start) {
        this.setYear(start.getYear());
        this.setDayOfYear(start.getDayOfYear());
        this.setHour(start.getHour());
        this.setMinute(start.getMinute());
        this.setSecond(start.getSecond());
        this.setNanosecond(start.getNano());
    }

    public ZonedDateTime getStartDateTime() {
        int sec = this.getSecond();
        int leaps = 0;
        if (sec > 59) {
            leaps = sec - 59;
            sec = 59;
        }
        ZonedDateTime out = ZonedDateTime.of(this.getYear(), 1, 1, this.getHour(), this.getMinute(), sec, this.getNanosecond(), TZ_UTC);
        out = out.plusDays(this.getDayOfYear() - 1);
        return out;
    }

    public boolean possibleLeapSecond() {
        boolean leapYear;
        boolean bl = leapYear = this.getYear() % 4 == 0 && (this.getYear() % 100 != 0 || this.getYear() % 400 == 0);
        if (leapYear && (this.getDayOfYear() == 182 || this.getDayOfYear() == 366) || !leapYear && (this.getDayOfYear() == 181 || this.getDayOfYear() == 365)) {
            ZonedDateTime midnight;
            ZonedDateTime start = this.getStartDateTime();
            ZonedDateTime end = this.getLastSampleTime();
            if (end.isAfter(midnight = ZonedDateTime.of(start.getYear(), start.getMonthValue(), start.getDayOfMonth(), 23, 59, 59, 0, TZ_UTC))) {
                return true;
            }
        }
        return false;
    }

    public String getStartTimeString() {
        return MSeed3Record.padToLength(this.getYear(), 4) + "-" + MSeed3Record.padToLength(this.getDayOfYear(), 3) + 'T' + MSeed3Record.padToLength(this.getHour(), 2) + ":" + MSeed3Record.padToLength(this.getMinute(), 2) + ":" + MSeed3Record.padToLength(this.getSecond(), 2) + MSeed3Record.nanosToString(this.getNanosecond()) + ZULU;
    }

    public static String nanosToString(int nanos) {
        String nanoStr = "";
        if (nanos == 0) {
            nanoStr = "";
        } else if (nanos % 1000000 == 0) {
            nanoStr = "." + MSeed3Record.padToLength(nanos / 1000000, 3);
        } else if (nanos % 1000 == 0) {
            nanoStr = "." + MSeed3Record.padToLength(nanos / 1000, 6);
        }
        return nanoStr;
    }

    private static String padToLength(int val, int length) {
        String out = "" + val;
        while (out.length() < length) {
            out = "0" + out;
        }
        return out;
    }

    public ZonedDateTime getLastSampleTime() {
        long nanoDuration = this.getSamplePeriodAsNanos() * (long)(this.getNumSamples() - 1);
        if (this.getSecond() < 60) {
            nanoDuration -= (long)this.getLeapSecInRecord() * 1000000000L;
        }
        return this.getStartDateTime().plusNanos(nanoDuration);
    }

    public ZonedDateTime getPredictedNextRecordStartTime() {
        long nanoDuration = this.getSamplePeriodAsNanos() * (long)this.getNumSamples();
        if (this.getSecond() < 60) {
            nanoDuration -= (long)this.getLeapSecInRecord() * 1000000000L;
        }
        return this.getStartDateTime().plusNanos(nanoDuration);
    }

    public String getLastSampleTimeString() {
        ZonedDateTime lst = this.getLastSampleTime();
        if (this.isEndTimeInLeapSecond()) {
            return DateTimeFormatter.ofPattern("yyyy-DDD'T'HH:mm:").format(lst) + MSeed3Record.padToLength(lst.getSecond() + this.getLeapSecInRecord(), 2) + MSeed3Record.nanosToString(lst.getNano()) + ZULU;
        }
        return DateTimeFormatter.ofPattern("yyyy-DDD'T'HH:mm:ss").format(lst) + MSeed3Record.nanosToString(lst.getNano()) + ZULU;
    }

    public long getSamplePeriodAsNanos() {
        if (this.getSampleRate() < 0.0) {
            return Math.round(-1.0 * this.getSampleRate() * 1.0E9);
        }
        return Math.round(1.0E9 / this.getSampleRate());
    }

    public boolean isStartTimeInLeapSecond() {
        return this.getLeapSecInRecord() > 0 && this.getSecond() == 60;
    }

    public boolean isEndTimeInLeapSecond() {
        ZonedDateTime start = this.getStartDateTime();
        long durNanos = this.getSamplePeriodAsNanos() * (long)(this.getNumSamples() - 1);
        ZonedDateTime predLastSampleTime = start.plus(Duration.ofNanos(durNanos));
        return this.getLeapSecInRecord() != 0 && (!this.isStartTimeInLeapSecond() && start.getDayOfYear() != predLastSampleTime.getDayOfYear() && predLastSampleTime.getSecond() == 0 && predLastSampleTime.getMinute() == 0 && predLastSampleTime.getHour() == 0 || this.isStartTimeInLeapSecond() && (long)start.getNano() + durNanos < 1000000000L);
    }

    public boolean isTimeTagQuestionable() {
        return (this.getFlags() & 2) == 2;
    }

    public void setTimeTagQuestionable(boolean b) {
        this.flags = b ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFD);
    }

    public boolean isClockLocked() {
        return (this.getFlags() & 4) == 4;
    }

    public void setClockLocked(boolean b) {
        this.flags = b ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFB);
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        PrintWriter out = new PrintWriter(buf);
        try {
            this.printASCII(out, "", false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public JSONObject getExtraHeaders() {
        if (this.extraHeaders == null) {
            if (this.getExtraHeadersAsString(0) == null || this.getExtraHeadersAsString(0).length() < 2) {
                this.extraHeaders = new JSONObject("{}");
                this.extraHeadersStr = null;
            } else {
                this.extraHeaders = new JSONObject(this.getExtraHeadersAsString(0));
                this.extraHeadersStr = null;
            }
        }
        return this.extraHeaders;
    }

    public String getRecordIndicator() {
        return this.recordIndicator;
    }

    public void setRecordIndicator(String recordIndicator) {
        this.recordIndicator = recordIndicator;
    }

    public byte getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(byte formatVersion) {
        this.formatVersion = formatVersion;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public String startFieldsInUtilFormat() {
        return this.year + "," + String.format("%03d", this.dayOfYear) + "," + String.format("%02d", this.hour) + ":" + String.format("%02d", this.minute) + ":" + String.format("%02d", this.second) + "." + String.format("%06d", (int)Math.floor(this.nanosecond / 1000));
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getDayOfYear() {
        return this.dayOfYear;
    }

    public void setDayOfYear(int dayOfYear) {
        this.dayOfYear = dayOfYear;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public int getNanosecond() {
        return this.nanosecond;
    }

    public void setNanosecond(int nanosecond) {
        this.nanosecond = nanosecond;
    }

    public double getSampleRatePeriod() {
        return this.sampleRatePeriod;
    }

    public void setSampleRatePeriod(double sampleRatePeriod) {
        this.sampleRatePeriod = sampleRatePeriod;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public byte getTimeseriesEncodingFormat() {
        return this.timeseriesEncodingFormat;
    }

    public String getTimeseriesEncodingFormatName() {
        switch (this.timeseriesEncodingFormat) {
            case 0: {
                return "Text";
            }
            case 1: {
                return "16-bit integer";
            }
            case 2: {
                return "24-bit integer";
            }
            case 3: {
                return "32-bit integer";
            }
            case 4: {
                return "32-bit float (IEEE single)";
            }
            case 5: {
                return "64-bit float (IEEE double)";
            }
            case 10: {
                return "STEIM-1 integer compression";
            }
            case 11: {
                return "STEIM-2 integer compression";
            }
            case 12: {
                return "GEOSCOPE Muxed 24-bit integer";
            }
            case 13: {
                return "GEOSCOPE Muxed 16/3-bit gain/exp";
            }
            case 14: {
                return "GEOSCOPE Muxed 16/4-bit gain/exp";
            }
            case 15: {
                return "US National Network compression";
            }
            case 16: {
                return "CDSN 16-bit gain ranged";
            }
            case 17: {
                return "Graefenberg 16-bit gain ranged";
            }
            case 18: {
                return "IPG - Strasbourg 16-bit gain";
            }
            case 19: {
                return "STEIM-3 integer compression";
            }
            case 30: {
                return "SRO gain ranged";
            }
            case 31: {
                return "HGLP";
            }
            case 32: {
                return "DWWSSN";
            }
            case 33: {
                return "RSTN 16 bit gain ranged";
            }
        }
        return "Unknown";
    }

    public void setTimeseriesEncodingFormat(byte timeseriesEncodingFormat) {
        this.timeseriesEncodingFormat = timeseriesEncodingFormat;
    }

    public byte getPublicationVersion() {
        return this.publicationVersion;
    }

    public void setPublicationVersion(byte publicationVersion) {
        this.publicationVersion = publicationVersion;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public int getRecordCRC() {
        return this.recordCRC;
    }

    public void setRecordCRC(int recordCRC) {
        this.recordCRC = recordCRC;
    }

    public String getExtraHeadersAsString(int indent) {
        String ehStr;
        if (this.extraHeaders == null) {
            if (this.extraHeadersStr == null) {
                this.extraHeadersStr = "";
            }
            ehStr = this.extraHeadersStr;
        } else {
            ehStr = this.extraHeaders.toString(indent);
        }
        return ehStr;
    }

    public void setExtraHeaders(String extraHeaders) {
        this.extraHeadersStr = extraHeaders;
        this.extraHeaders = null;
    }

    public void setExtraHeaders(JSONObject extraHeaders) {
        this.extraHeaders = extraHeaders;
        this.extraHeadersStr = null;
    }

    public FDSNSourceId getSourceId() {
        return this.sourceId;
    }

    public String getSourceIdStr() {
        if (this.sourceId != null) {
            return this.sourceId.toString();
        }
        return this.sourceIdStr;
    }

    public void setSourceId(String sourceId) {
        this.sourceIdStr = sourceId;
        this.sourceId = null;
        this.sourceIdByteLength = (byte)this.sourceIdStr.length();
    }

    public void setSourceId(FDSNSourceId sourceId) {
        this.sourceIdStr = null;
        this.sourceId = sourceId;
        this.sourceIdByteLength = 0;
    }

    public byte getSourceIdByteLength() {
        return this.sourceIdByteLength;
    }

    public int calcExtraHeadersByteLength() {
        return this.getExtraHeaders().toString().getBytes().length;
    }

    public int getExtraHeadersByteLength() {
        return this.extraHeadersByteLength;
    }

    public int getDataByteLength() {
        return this.dataByteLength;
    }

    public byte[] getTimeseriesBytes() {
        return this.timeseriesBytes;
    }

    public void setTimeseriesBytes(byte[] timeseriesBytes) {
        this.timeseriesBytes = timeseriesBytes;
    }

    public void setTimeseries(short[] data) {
        Codec codec = new Codec();
        byte[] bData = codec.encodeAsBytes(data);
        this.setTimeseriesBytes(bData);
        this.setTimeseriesEncodingFormat((byte)1);
    }

    public void setTimeseries(int[] data) {
        Codec codec = new Codec();
        byte[] bData = codec.encodeAsBytes(data);
        this.setTimeseriesBytes(bData);
        this.setTimeseriesEncodingFormat((byte)3);
    }

    public void setTimeseries(float[] data) {
        Codec codec = new Codec();
        byte[] bData = codec.encodeAsBytes(data);
        this.setTimeseriesBytes(bData);
        this.setTimeseriesEncodingFormat((byte)4);
    }

    public void setTimeseries(double[] data) {
        Codec codec = new Codec();
        byte[] bData = codec.encodeAsBytes(data);
        this.setTimeseriesBytes(bData);
        this.setTimeseriesEncodingFormat((byte)5);
    }

    public DecompressedData decompress() throws SeedFormatException, UnsupportedCompressionType, CodecException {
        if (this.getNumSamples() == 0) {
            return new DecompressedData(new int[0]);
        }
        Codec codec = new Codec();
        return codec.decompress((int)this.getTimeseriesEncodingFormat(), this.getTimeseriesBytes(), this.getNumSamples(), true);
    }

    public int getSize() {
        return 40 + this.getSourceIdByteLength() + this.getExtraHeadersByteLength() + this.getDataByteLength();
    }
}

