/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed3;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette100;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Blockette1001;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.MSeed3Record;
import org.json.JSONObject;

public class MSeed3Convert {
    public static MSeed3Record convert2to3(DataRecord dr) throws SeedFormatException {
        MSeed3Record ms3Header = new MSeed3Record();
        DataHeader ms2H = dr.getHeader();
        ms3Header.flags = (byte)((ms2H.getActivityFlags() & 1) * 2 + (ms2H.getIOClockFlags() & 0x40) * 4 + (ms2H.getDataQualityFlags() & 0x10) * 8);
        ms3Header.setPublicationVersion((byte)0);
        ms3Header.year = ms2H.getStartBtime().year;
        ms3Header.dayOfYear = ms2H.getStartBtime().jday;
        ms3Header.hour = ms2H.getStartBtime().hour;
        ms3Header.minute = ms2H.getStartBtime().min;
        ms3Header.second = ms2H.getStartBtime().sec;
        ms3Header.nanosecond = ms2H.getStartBtime().tenthMilli * 100000;
        ms3Header.sampleRatePeriod = dr.getSampleRate() >= 1.0f ? (double)dr.getSampleRate() : -1.0 / (double)dr.getSampleRate();
        Blockette1000 b1000 = (Blockette1000)dr.getUniqueBlockette(1000);
        if (b1000 == null) {
            throw new MissingBlockette1000(dr.getHeader());
        }
        ms3Header.timeseriesEncodingFormat = b1000.getEncodingFormat();
        ms3Header.publicationVersion = 0;
        ms3Header.dataByteLength = dr.getData().length;
        ms3Header.setSourceId(FDSNSourceId.fromNSLC(dr.getHeader().getNetworkCode(), dr.getHeader().getStationIdentifier(), dr.getHeader().getLocationIdentifier(), dr.getHeader().getChannelIdentifier()));
        ms3Header.numSamples = ms2H.getNumSamples();
        ms3Header.recordCRC = 0;
        JSONObject ms3Extras = new JSONObject();
        if (ms2H.getTypeCode() != '\u0000' && ms2H.getTypeCode() != 'D') {
            ms3Extras.put("QI", (int)ms2H.getTypeCode());
        }
        int nanos = 0;
        Blockette[] blockettes = dr.getBlockettes(100);
        if (blockettes.length != 0) {
            Blockette100 b100 = (Blockette100)blockettes[0];
            ms3Header.setSampleRate(b100.getActualSampleRate());
        }
        if ((blockettes = dr.getBlockettes(100)).length != 0) {
            Blockette1001 b1001 = (Blockette1001)blockettes[0];
            nanos = 1000 * b1001.getMicrosecond();
            ms3Extras.put("TQ", (int)b1001.getTimingQuality());
        }
        if (dr.getHeader().getStartBtime().sec == 60) {
            ms3Extras.put("TimeLeapSecond", 1);
        }
        ms3Header.setNanosecond(ms3Header.getNanosecond() + nanos);
        if (ms3Header.nanosecond < 0) {
            --ms3Header.second;
            ms3Header.nanosecond += 1000000000;
            if (ms3Header.second < 0) {
                ms3Header.second += 60;
                --ms3Header.minute;
                if (ms3Header.minute < 0) {
                    ms3Header.minute += 60;
                    --ms3Header.hour;
                    if (ms3Header.hour < 0) {
                        ms3Header.hour += 24;
                        ms3Header.dayOfYear = -1;
                        if (ms3Header.dayOfYear < 0) {
                            ms3Header.dayOfYear += 365;
                            --ms3Header.year;
                        }
                    }
                }
            }
        }
        ms3Header.setExtraHeaders(ms3Extras.toString());
        ms3Header.timeseriesBytes = dr.getData();
        return ms3Header;
    }
}

