/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.BlocketteFactory;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.ControlRecord;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DefaultBlocketteFactory;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.PartialBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class SeedRecord {
    protected static BlocketteFactory blocketteFactory = new DefaultBlocketteFactory();
    public static final String DEFAULT_INDENT = "  ";
    protected ControlHeader header;
    protected List<Blockette> blockettes = new ArrayList<Blockette>();
    protected int RECORD_SIZE = 4096;

    public static void setBlocketteFactory(BlocketteFactory bf) {
        blocketteFactory = bf;
    }

    public static BlocketteFactory getBlocketteFactory() {
        return blocketteFactory;
    }

    public static SeedRecord read(DataInput inStream) throws IOException, SeedFormatException {
        return SeedRecord.read(inStream, 0);
    }

    public static SeedRecord read(byte[] bytes) throws IOException, SeedFormatException {
        DataInputStream seedIn = new DataInputStream(new ByteArrayInputStream(bytes));
        return DataRecord.read(seedIn);
    }

    public static SeedRecord read(DataInput inStream, int defaultRecordSize) throws IOException, SeedFormatException {
        boolean resetOnError;
        boolean bl = resetOnError = inStream instanceof DataInputStream && ((InputStream)((Object)inStream)).markSupported();
        if (resetOnError) {
            ((InputStream)((Object)inStream)).mark(defaultRecordSize != 0 ? defaultRecordSize : 4096);
        }
        try {
            SeedRecord newRecord;
            ControlHeader header = ControlHeader.read(inStream);
            if (header instanceof DataHeader) {
                newRecord = DataRecord.readDataRecord(inStream, (DataHeader)header, defaultRecordSize);
            } else {
                ControlRecord contRec = ControlRecord.readControlRecord(inStream, header, defaultRecordSize);
                defaultRecordSize = contRec.getRecordSize();
                newRecord = contRec;
            }
            return newRecord;
        }
        catch (SeedFormatException e) {
            if (resetOnError) {
                try {
                    ((InputStream)((Object)inStream)).reset();
                }
                catch (IOException ee) {
                    throw e;
                }
            }
            throw e;
        }
        catch (IOException e) {
            if (resetOnError) {
                try {
                    ((InputStream)((Object)inStream)).reset();
                }
                catch (IOException ee) {
                    throw e;
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (resetOnError) {
                try {
                    ((InputStream)((Object)inStream)).reset();
                }
                catch (IOException ee) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public SeedRecord(ControlHeader header) {
        this.header = header;
    }

    public void addBlockette(Blockette b) throws SeedFormatException {
        this.blockettes.add(b);
    }

    public Blockette[] getBlockettes() {
        return this.blockettes.toArray(new Blockette[0]);
    }

    public Blockette getUniqueBlockette(int type) throws SeedFormatException {
        Blockette[] b = this.getBlockettes(type);
        if (b.length == 1) {
            return b[0];
        }
        if (b.length == 0) {
            if (type == 1000) {
                throw new MissingBlockette1000(this.getControlHeader());
            }
            throw new SeedFormatException("No blockettes of type " + type);
        }
        throw new SeedFormatException("Multiple blockettes of type " + type);
    }

    public int getNumBlockettes(int type) throws SeedFormatException {
        int out = 0;
        for (Blockette b : this.blockettes) {
            if (b.getType() != type) continue;
            ++out;
        }
        return out;
    }

    public Blockette[] getBlockettes(int type) {
        ArrayList<Blockette> out = new ArrayList<Blockette>();
        for (Blockette b : this.blockettes) {
            if (b.getType() != type) continue;
            out.add(b);
        }
        return out.toArray(new Blockette[0]);
    }

    public PartialBlockette getFirstPartialBlockette() {
        if (this.blockettes.get(0) instanceof PartialBlockette) {
            return (PartialBlockette)this.blockettes.get(0);
        }
        return null;
    }

    public PartialBlockette getLastPartialBlockette() {
        if (this.blockettes.size() != 0 && this.blockettes.get(this.blockettes.size() - 1) instanceof PartialBlockette) {
            return (PartialBlockette)this.blockettes.get(this.blockettes.size() - 1);
        }
        return null;
    }

    public ControlHeader getControlHeader() {
        return this.header;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter p = new PrintWriter(sw);
        try {
            this.writeASCII(p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        p.close();
        return sw.toString();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.writeASCII(out, "");
    }

    public void writeASCII(PrintWriter out, String indent) throws IOException {
        if (this instanceof DataRecord) {
            out.print(indent + "DataRecord");
        } else if (this instanceof ControlRecord) {
            out.print(indent + "ControlRecord");
        } else {
            out.print(indent + "SeedRecord");
        }
        this.getControlHeader().writeASCII(out, indent + DEFAULT_INDENT);
        for (Blockette b : this.blockettes) {
            b.writeASCII(out, indent + DEFAULT_INDENT + DEFAULT_INDENT);
        }
    }

    public int getRecordSize() {
        return this.RECORD_SIZE;
    }
}

