/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQuerier;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventParameters;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.net.ssl.SSLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.http.client.methods.CloseableHttpResponse;

public class Quakeml {
    EventParameters eventParameters;
    XMLEventReader reader;
    String schemaVersion;
    CloseableHttpResponse response;
    FDSNEventQuerier querier;

    public static Quakeml createEmptyQuakeML() {
        try {
            URL url = Quakeml.class.getClassLoader().getResource("edu/sc/seis/seisFile/quakeml/1.2/empty.quakeml");
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader r = factory.createXMLEventReader(url.toString(), url.openStream());
            return new Quakeml(r);
        }
        catch (Exception e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public static URL findInternalSchema() {
        return FDSNStationXML.class.getClassLoader().getResource("edu/sc/seis/seisFile/quakeml/1.2/QuakeML-1.2.xsd");
    }

    public static URL findInternalBEDSchema() {
        return FDSNStationXML.class.getClassLoader().getResource("edu/sc/seis/seisFile/quakeml/1.2/QuakeML-BED-1.2.xsd");
    }

    public static void printSchema(OutputStream out) throws IOException {
        BufferedInputStream bufIn = new BufferedInputStream(Quakeml.findInternalBEDSchema().openStream());
        BufferedOutputStream bufOut = new BufferedOutputStream(out);
        byte[] buf = new byte[1024];
        int numRead = bufIn.read(buf);
        while (numRead != -1) {
            bufOut.write(buf, 0, numRead);
            numRead = bufIn.read(buf);
        }
        bufIn.close();
        bufOut.flush();
    }

    public Quakeml(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        this.reader = reader;
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("quakeml", reader);
        this.schemaVersion = startE.getName().getNamespaceURI();
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("eventParameters")) {
                    this.eventParameters = new EventParameters(reader);
                    break;
                }
                System.err.println("QuakeML skipping " + elName);
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public boolean checkSchemaVersion() {
        return "http://quakeml.org/xmlns/quakeml/1.2".equals(this.schemaVersion);
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.reader = null;
        if (this.response != null) {
            try {
                this.response.close();
            }
            catch (SSLException sSLException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.response = null;
    }

    public EventParameters getEventParameters() {
        return this.eventParameters;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setEventParameters(EventParameters eventParameters) {
        this.eventParameters = eventParameters;
    }

    public void setQuerier(FDSNEventQuerier q) {
        this.querier = q;
    }

    public void setResponse(CloseableHttpResponse response) {
        this.response = response;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }
}

