/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.datalink;

import edu.sc.seis.seisFile.datalink.DataLinkException;
import edu.sc.seis.seisFile.datalink.DataLinkHeader;
import edu.sc.seis.seisFile.datalink.DataLinkMessage;
import edu.sc.seis.seisFile.datalink.DataLinkPacket;
import edu.sc.seis.seisFile.datalink.DataLinkResponse;
import edu.sc.seis.seisFile.datalink.PacketHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class DataLink {
    private PrintWriter verboseWriter;
    Socket socket;
    BufferedOutputStream out;
    PushbackInputStream in;
    DataInputStream inData;
    String url;
    String mode;
    String serverId;
    int clientIdNum;
    String username;
    String matchRegEx = null;
    String rejectRegEx = null;
    PacketHandler packetHandler;
    boolean verbose = false;
    String host;
    int port;
    int timeoutSeconds = 120;
    int connectTimeoutSeconds = 120;
    public static final String IRIS_HOST = "rtserve.iris.washington.edu";
    public static final int IRIS_PORT = 18000;
    public static final String EEYORE_HOST = "eeyore.seis.sc.edu";
    public static final int EEYORE_PORT = 6383;
    public static final String DEFAULT_HOST = "eeyore.seis.sc.edu";
    public static final int DEFAULT_PORT = 6383;
    public static final int DEFAULT_TIMEOUT_SECOND = 120;
    public static final String DATALINK_PROTOCOL = "1.0";
    public static final String QUERY_MODE = "QUERY";
    public static final String STREAM_MODE = "STREAM";
    public static final int MAX_PROC_NUM = 65534;
    public static final String USER_BROWSER = "browser";
    public static final String ID = "ID";
    public static final String OK = "OK";
    public static final String ERROR = "ERROR";
    public static final String INFO = "INFO";
    public static final String MATCH = "MATCH";
    public static final String REJECT = "REJECT";
    public static final String PACKET = "PACKET";
    public static final String STREAM = "STREAM";
    public static final String ENDSTREAM = "ENDSTREAM";
    public static final String MSEED_TYPE = "MSEED";

    public DataLink() throws DataLinkException {
        this("eeyore.seis.sc.edu", 6383);
    }

    public DataLink(String host) throws DataLinkException {
        this(host, 6383);
    }

    public DataLink(String host, int port) throws DataLinkException {
        this(host, port, 120);
    }

    public DataLink(String host, int port, int timeoutSeconds) throws DataLinkException {
        this(host, port, timeoutSeconds, false);
    }

    public DataLink(String host, int port, int timeoutSeconds, boolean verbose) throws DataLinkException {
        this.host = host;
        this.port = port;
        this.setVerbose(verbose);
        this.timeoutSeconds = timeoutSeconds;
        this.clientIdNum = 42;
        this.username = "unknown";
        this.initConnection();
    }

    private void initConnection() throws DataLinkException {
        try {
            this.verbose("initConnection to " + this.host + ":" + this.port);
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, this.port), this.connectTimeoutSeconds * 1000);
            this.socket.setSoTimeout(this.timeoutSeconds * 1000);
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new PushbackInputStream(new BufferedInputStream(this.socket.getInputStream()), 3);
            this.inData = new DataInputStream(this.in);
            this.mode = QUERY_MODE;
            this.verbose("Connection made");
            this.sendId();
            while (this.availableBytes() < 3) {
                this.verbose("not bytes available " + this.availableBytes());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.verbose("readPacket");
            DataLinkResponse dlr = this.readPacket();
            if (dlr.getKey().equals(ID) && dlr.headerSplit(1).equals("DataLink")) {
                this.serverId = dlr.getHeaderString();
            } else {
                this.verbose("Not ID response: " + dlr.getKey() + "  " + dlr.headerSplit(1) + "  " + dlr.getHeaderString());
            }
        }
        catch (UnknownHostException e) {
            throw new DataLinkException(e);
        }
        catch (IOException e) {
            throw new DataLinkException(e);
        }
    }

    public DataLinkResponse readPacket() throws IOException, DataLinkException {
        if (!this.isConnected()) {
            throw new DataLinkException("closed");
        }
        byte[] startBits = new byte[3];
        if (this.isVerbose()) {
            this.verboseWriter.println("readPacket(): blocking read for " + startBits.length + " bytes, available=" + this.availableBytes());
        }
        startBits[0] = (byte)this.in.read();
        startBits[1] = (byte)this.in.read();
        if (startBits[0] != 68 || startBits[1] != 76) {
            throw new DataLinkException("Expected DL as first two bytes but was :" + startBits[0] + " " + startBits[1]);
        }
        byte headerSize = (byte)this.in.read();
        byte[] headerBytes = new byte[headerSize];
        this.inData.readFully(headerBytes);
        String headerStr = new String(headerBytes);
        DataLinkHeader header = new DataLinkHeader(headerStr);
        DataLinkResponse out = null;
        byte[] rawData = new byte[header.getDataSize()];
        this.inData.readFully(rawData);
        if (header.getKey().startsWith(PACKET)) {
            out = new DataLinkPacket(header, rawData);
        } else if (header.isMessageType()) {
            out = new DataLinkMessage(header, new String(rawData));
        } else {
            throw new DataLinkException("Unknown packet type: " + header.getKey());
        }
        return out;
    }

    public void stream() throws DataLinkException {
        if (this.mode.equals("STREAM")) {
            return;
        }
        this.sendDLCommand("STREAM", null);
        this.mode = "STREAM";
    }

    public void endStream() throws DataLinkException {
        if (this.mode.equals(QUERY_MODE)) {
            return;
        }
        this.mode = QUERY_MODE;
        this.sendDLCommand(ENDSTREAM, null);
    }

    public void match(String matchRegEx) throws DataLinkException {
        if (this.mode == "STREAM") {
            this.endStream();
        }
        this.matchRegEx = matchRegEx;
        this.sendDLCommand(MATCH, matchRegEx);
    }

    public void reject(String rejectRegEx) throws DataLinkException {
        if (this.mode == "STREAM") {
            this.endStream();
        }
        this.rejectRegEx = rejectRegEx;
        this.sendDLCommand(REJECT, rejectRegEx);
    }

    public boolean available() throws IOException {
        if (!this.isConnected()) {
            return false;
        }
        return this.in.available() > 3;
    }

    public int availableBytes() throws IOException {
        return this.in.available();
    }

    public void close() {
        try {
            this.endStream();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.in.close();
            this.out.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
        this.in = null;
        this.out = null;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void reconnect() throws IOException, DataLinkException {
        String prevMode = this.mode;
        this.close();
        this.initConnection();
        if (this.matchRegEx != null) {
            this.sendDLCommand(MATCH, this.matchRegEx);
        }
        if (this.rejectRegEx != null) {
            this.sendDLCommand(REJECT, this.rejectRegEx);
        }
        if (prevMode == "STREAM") {
            this.stream();
        }
    }

    public byte[] encodeDLCommand(String command, String dataString) throws DataLinkException {
        int cmdLen = command.length();
        int len = 3 + command.length();
        String lenStr = "";
        if (dataString != null && dataString.length() > 0) {
            lenStr = "" + dataString.length();
            len += lenStr.length() + 1;
            cmdLen += lenStr.length() + 1;
            len += dataString.length();
        }
        if (len > 256) {
            throw new DataLinkException("command string too long: " + len);
        }
        byte[] packet = new byte[len];
        packet[0] = 68;
        packet[1] = 76;
        packet[2] = (byte)cmdLen;
        byte[] commandBytes = command.getBytes();
        System.arraycopy(commandBytes, 0, packet, 3, commandBytes.length);
        int i = 3 + commandBytes.length;
        int SPACE = 32;
        if (dataString != null && dataString.length() > 0) {
            packet[i] = SPACE;
            byte[] lenStrBytes = lenStr.getBytes();
            System.arraycopy(lenStrBytes, 0, packet, ++i, lenStrBytes.length);
            byte[] dataStringBytes = dataString.getBytes();
            System.arraycopy(dataStringBytes, 0, packet, i += lenStrBytes.length, dataStringBytes.length);
        }
        return packet;
    }

    public void sendDLCommand(String command, String dataString) throws DataLinkException {
        if (!this.mode.equals(QUERY_MODE)) {
            throw new DataLinkException("Cannot send command unless in QUERY_MODE, use endStream() first.");
        }
        if (this.isVerbose()) {
            this.verboseWriter.println("send '" + command + " | " + (dataString != null ? dataString : "") + "'");
        }
        byte[] rawPacket = this.encodeDLCommand(command, dataString);
        if (this.socket != null && this.out != null) {
            try {
                this.out.write(rawPacket);
                this.out.flush();
            }
            catch (IOException e) {
                throw new DataLinkException(e);
            }
        } else {
            throw new DataLinkException("Socket has been closed.");
        }
    }

    public DataLinkResponse awaitDLCommand(String command, String dataString) throws DataLinkException {
        DataLinkResponse resp;
        this.sendDLCommand(command, dataString);
        try {
            resp = this.readPacket();
        }
        catch (IOException e) {
            throw new DataLinkException("Unable to get response to command: " + command, e);
        }
        if (resp.getKey().equals(OK)) {
            return resp;
        }
        if (resp.getKey().equals(ERROR)) {
            return resp;
        }
        throw new DataLinkException("Unknown response, was expecting OK or ERROR");
    }

    public void sendId() throws DataLinkException {
        this.verbose("sendId");
        this.sendDLCommand("ID seisFile:" + this.username + ":" + this.clientIdNum + ":java", null);
    }

    public void verbose(String message) {
        if (this.isVerbose()) {
            this.getVerboseWriter().println(message);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (verbose && this.verboseWriter == null) {
            this.verboseWriter = new PrintWriter(System.out, true);
        }
    }

    public PrintWriter getVerboseWriter() {
        if (this.verboseWriter == null) {
            this.verboseWriter = new PrintWriter(System.out);
        }
        return this.verboseWriter;
    }

    public void setVerboseWriter(PrintWriter verboseWriter) {
        this.verboseWriter = verboseWriter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getClientIdNum() {
        return this.clientIdNum;
    }

    public String getUsername() {
        return this.username;
    }
}

