/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.ToolRun;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class TauP_Curve
extends TauP_Time {
    protected boolean gmtScript = false;
    protected boolean svgOutput = false;
    protected boolean reduceTime = false;
    protected double reduceVel = 0.002181661564992912;
    protected String redVelString = ".125 deg/s";
    protected float mapWidth = 6.0f;
    protected String mapWidthUnit = "i";

    protected TauP_Curve() {
        this.setOutFileBase("taup_curve");
    }

    public TauP_Curve(TauModel tMod) throws TauModelException {
        super(tMod);
    }

    public TauP_Curve(String modelName) throws TauModelException {
        super(modelName);
    }

    public boolean isGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean gmtScript) {
        this.gmtScript = gmtScript;
    }

    public boolean isReduceTime() {
        return this.reduceTime;
    }

    public void setReduceTime(boolean reduceTime) {
        this.reduceTime = reduceTime;
    }

    public double getReduceVelDeg() {
        return 57.29577951308232 * this.reduceVel;
    }

    public void setReduceVelDeg(double reduceVel) {
        if (reduceVel > 0.0) {
            this.redVelString = reduceVel + " deg/s";
            this.reduceVel = Math.PI / 180 * reduceVel;
        }
    }

    public double getReduceVelKm() {
        return this.reduceVel * this.tMod.getRadiusOfEarth();
    }

    public void setReduceVelKm(double reduceVel) {
        this.redVelString = reduceVel + " km/s";
        if (reduceVel > 0.0) {
            this.reduceVel = this.tMod != null ? reduceVel / this.tMod.getRadiusOfEarth() : reduceVel / 6371.0;
        } else {
            throw new IllegalArgumentException("Reducing velocity must be positive: " + reduceVel);
        }
    }

    public void setMapWidth(float mapWidth) {
        this.mapWidth = mapWidth;
    }

    public float getMapWidth() {
        return this.mapWidth;
    }

    public String getMapWidthUnit() {
        return this.mapWidthUnit;
    }

    public void setMapWidthUnit(String mapWidthUnit) {
        this.mapWidthUnit = mapWidthUnit;
    }

    @Override
    public void calculate(double degrees) throws TauModelException {
        this.depthCorrect(this.getSourceDepth(), this.getReceiverDepth());
    }

    @Override
    public void printScriptBeginning(PrintWriter out) throws IOException {
        if (this.gmtScript) {
            String psFile = this.getOutFile().endsWith(".gmt") ? this.getOutFile().substring(0, this.getOutFile().length() - 4) + ".ps" : this.getOutFile() + ".ps";
            this.getWriter().println("#!/bin/sh");
            this.getWriter().println("#\n# This script will plot curves using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, as well as the last line.\n#");
            this.getWriter().println("/bin/rm -f " + psFile + "\n");
        } else if (this.svgOutput) {
            int plotOffset = 20;
            int plotSize = 500;
            out.println("<svg version=\"1.1\" baseProfile=\"full\" xmlns=\"http://www.w3.org/2000/svg\" width=\"500\" height=\"500\" viewBox=\"0 0 " + plotSize + " " + plotSize + "\">");
            out.println("<!--\n This script will travel time curves generated by TauP using SVG. -->");
            out.println("<defs>");
            out.println("    <style type=\"text/css\"><![CDATA[");
            out.println("        circle {");
            out.println("            vector-effect: non-scaling-stroke;");
            out.println("            stroke: grey;");
            out.println("            fill: transparent;");
            out.println("        }");
            out.println("        polyline {");
            out.println("            vector-effect: non-scaling-stroke;");
            out.println("            stroke: black;");
            out.println("            fill: transparent;");
            out.println("        }");
            out.println("    ]]></style>");
            out.println("</defs>");
            out.println("<g transform=\"translate(" + plotOffset + "," + plotOffset + ")\" >");
            out.println("<!-- draw axis and label distances.-->");
        }
    }

    @Override
    public void printStdUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        System.out.println("Usage: " + className.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n-h depth           -- source depth in km\n\n");
    }

    @Override
    public void printUsage() {
        this.printStdUsage();
        System.out.println("--gmt              -- outputs curves as a complete GMT script.");
        System.out.println("-reddeg velocity   -- outputs curves with a reducing velocity (deg/sec).");
        System.out.println("-redkm velocity    -- outputs curves with a reducing velocity (km/sec).");
        System.out.println("-rel phasename     -- outputs relative travel time");
        System.out.println("--mapwidth width   -- sets map width for GMT script.");
        TauP_Curve.printStdUsageTail();
    }

    @Override
    public void start() throws IOException, TauModelException {
        if (this.depth != -1.7976931348623157E308) {
            this.setSourceDepth(Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0")));
            this.calculate(this.degrees);
            this.printResult(this.getWriter());
        } else {
            StreamTokenizer tokenIn = new StreamTokenizer(new InputStreamReader(System.in));
            tokenIn.parseNumbers();
            tokenIn.wordChars(44, 44);
            tokenIn.wordChars(95, 95);
            System.out.print("Enter Depth: ");
            tokenIn.nextToken();
            double tempDepth = tokenIn.nval;
            if (tempDepth < 0.0 || this.depth > this.tMod.getRadiusOfEarth()) {
                System.out.println("Depth must be >= 0.0 and <= tMod.getRadiusOfEarth().\ndepth = " + tempDepth);
                return;
            }
            this.setSourceDepth(tempDepth);
            this.calculate(this.degrees);
            this.printResult(this.getWriter());
        }
    }

    @Override
    public void destroy() throws TauPException {
        if (this.gmtScript && this.writer != null) {
            this.writer.close();
        }
        super.destroy();
    }

    @Override
    public void printResult(PrintWriter out) throws IOException {
        int i;
        double[] time;
        double[] dist;
        SeismicPhase phase;
        double maxTime = -1.7976931348623157E308;
        double minTime = Double.MAX_VALUE;
        ArrayList<SeismicPhase> relPhases = new ArrayList<SeismicPhase>();
        if (this.relativePhaseName != "") {
            try {
                List<String> splitNames = TauP_Curve.getPhaseNames(this.relativePhaseName);
                for (String sName : splitNames) {
                    relPhases.add(new SeismicPhase(sName, this.getTauModelDepthCorrected()));
                }
            }
            catch (TauModelException e) {
                Alert.warning("Error with phase=" + this.relativePhaseName, e.getMessage() + "\nSkipping relative phase");
            }
        }
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        String psFile = null;
        if (this.gmtScript) {
            String scriptStuff = "";
            psFile = this.getOutFile().endsWith(".gmt") ? this.getOutFile().substring(0, this.getOutFile().length() - 4) + ".ps" : this.getOutFile() + ".ps";
            String title = this.modelName + " (h=" + this.getSourceDepth() + " km)";
            if (this.reduceTime) {
                title = title + " reduce vel " + this.redVelString;
            } else if (this.relativePhaseName != "") {
                title = title + " relative phase " + this.relativePhaseName;
            }
            for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                double[] timeValue;
                phase = phaseList.get(phaseNum);
                if (!phase.hasArrivals()) continue;
                dist = phase.getDist();
                time = phase.getTime();
                int phaseMinIndex = 0;
                int phaseMaxIndex = 0;
                double phaseMaxTime = -1.7976931348623157E308;
                double phaseMinTime = Double.MAX_VALUE;
                for (i = 0; i < time.length; ++i) {
                    timeValue = this.calcTimeValue(dist[i], time[i], relPhases);
                    if (timeValue.length == 0) continue;
                    if (timeValue[0] > maxTime) {
                        maxTime = timeValue[0];
                    }
                    if (timeValue[0] < minTime) {
                        minTime = timeValue[0];
                    }
                    if (timeValue[0] > phaseMaxTime) {
                        phaseMaxTime = timeValue[0];
                        phaseMaxIndex = i;
                    }
                    if (!(timeValue[0] < phaseMinTime)) continue;
                    phaseMinTime = timeValue[0];
                    phaseMinIndex = i;
                }
                int midSample = dist.length / 2;
                double arcDistance = Math.acos(Math.cos(dist[midSample]));
                if (this.reduceTime || this.relativePhaseName != "") {
                    double labelTime;
                    timeValue = this.calcTimeValue(dist[midSample], time[midSample], relPhases);
                    if (timeValue.length == 0) {
                        arcDistance = Math.acos(Math.cos(dist[phaseMaxIndex]));
                        labelTime = phaseMaxTime;
                    } else {
                        labelTime = timeValue[0];
                    }
                    scriptStuff = scriptStuff + (float)(57.29577951308232 * arcDistance) + "  " + (float)phaseMaxTime + " 10 0 0 9 " + phase.getName() + "\n";
                    continue;
                }
                int lix = dist[1] > Math.PI ? 1 : dist.length - 1;
                double ldel = 57.29577951308232 * Math.acos(Math.cos(dist[midSample]));
                scriptStuff = scriptStuff + (float)ldel + "  " + (float)time[midSample] + " 10 0 0 1 " + phase.getName() + "\n";
            }
            maxTime = Math.ceil(maxTime / 100.0) * 100.0;
            minTime = Math.floor(minTime / 100.0) * 100.0;
            out.println("gmt psbasemap -JX" + this.getMapWidth() + this.getMapWidthUnit() + " -P -R0/180/" + minTime + "/" + maxTime + " -Bxa20+l'Distance (deg)' -Bya100+l'Time (sec)' -BWSne+t'" + title + "' -K > " + psFile);
            out.println("gmt pstext -JX -P -R  -O -K >> " + psFile + " <<END");
            out.print(scriptStuff);
            out.println("END\n");
            out.println("gmt psxy -JX -R -m -O -K >> " + psFile + " <<END");
        }
        double minDist = 0.0;
        double maxDist = Math.PI;
        if (this.relativePhaseName != "") {
            for (SeismicPhase seismicPhase : relPhases) {
                double[] relDist = seismicPhase.getDist();
                if (relDist.length == 0) continue;
                minDist = relDist[0];
                maxDist = relDist[0];
                for (int i2 = 0; i2 < relDist.length; ++i2) {
                    if (relDist[i2] < minDist) {
                        minDist = relDist[i2];
                    }
                    if (!(relDist[i2] > maxDist)) continue;
                    maxDist = relDist[i2];
                }
            }
        }
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            phase = phaseList.get(phaseNum);
            if (phase.hasArrivals()) {
                dist = phase.getDist();
                time = phase.getTime();
                double[] rayParams = phase.getRayParams();
                double minPhaseDist = dist[0];
                double maxPhaseDist = dist[0];
                if (this.relativePhaseName != "") {
                    for (i = 0; i < dist.length; ++i) {
                        if (dist[i] < minPhaseDist) {
                            minDist = dist[i];
                        }
                        if (!(dist[i] > maxPhaseDist)) continue;
                        maxDist = dist[i];
                    }
                }
                if (dist.length > 0) {
                    out.print("> " + phase.getName() + " for a source depth of " + this.depth + " kilometers in the " + this.modelName + " model");
                    if (this.relativePhaseName != "") {
                        out.print(" relative to " + this.relativePhaseName);
                    }
                    out.println();
                }
                for (i = 0; i < dist.length; ++i) {
                    this.writeValue(dist[i], time[i], relPhases, out);
                    if (i < dist.length - 1 && rayParams[i] == rayParams[i + 1] && rayParams.length > 2) {
                        out.println("> Shadow Zone");
                        continue;
                    }
                    this.checkBoundary(0.0, i, phase, relPhases, out);
                    this.checkBoundary(Math.PI, i, phase, relPhases, out);
                    if (minDist != 0.0 && minDist != Math.PI) {
                        this.checkBoundary(minDist, i, phase, relPhases, out);
                    }
                    if (maxDist == 0.0 || maxDist == Math.PI) continue;
                    this.checkBoundary(maxDist, i, phase, relPhases, out);
                }
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("Phase " + phase.getName() + " does not exist in " + phase.getTauModel().getModelName() + " for depth " + phase.getTauModel().getSourceDepth());
        }
        if (this.isGmtScript()) {
            out.println("END");
            this.endGmtAndCleanUp(out, psFile, "X");
        }
        out.flush();
    }

    protected void checkBoundary(double boundaryDistRadian, int distIndex, SeismicPhase phase, List<SeismicPhase> relPhase, PrintWriter out) throws IOException {
        double arcDistance = Math.acos(Math.cos(boundaryDistRadian));
        if (distIndex < phase.getDist().length - 1 && TauP_Curve.isBetween(Math.acos(Math.cos(phase.getDist()[distIndex])), Math.acos(Math.cos(phase.getDist()[distIndex + 1])), arcDistance)) {
            List<Arrival> phaseArrivals = phase.calcTime(arcDistance * 180.0 / Math.PI);
            for (Arrival arrival : phaseArrivals) {
                if (!((phase.rayParams[distIndex] - arrival.getRayParam()) * (arrival.getRayParam() - phase.rayParams[distIndex + 1]) > 0.0)) continue;
                this.writeValue(arcDistance, arrival.getTime(), relPhase, out);
                break;
            }
        }
    }

    protected double[] calcTimeValue(double distRadian, double time, List<SeismicPhase> relPhase) throws IOException {
        double timeReduced = time;
        double arcDistance = Math.acos(Math.cos(distRadian));
        double distDeg = arcDistance * 180.0 / Math.PI;
        if (this.reduceTime) {
            timeReduced = time - arcDistance / this.reduceVel;
        } else if (this.relativePhaseName != "") {
            this.relativeArrival = SeismicPhase.getEarliestArrival(relPhase, distDeg);
            if (this.relativeArrival == null) {
                return new double[0];
            }
            timeReduced = time - this.relativeArrival.getTime();
        } else {
            timeReduced = time;
        }
        return new double[]{timeReduced};
    }

    public void writeValue(double distRadian, double time, List<SeismicPhase> relPhase, PrintWriter out) throws IOException {
        double[] timeReduced = this.calcTimeValue(distRadian, time, relPhase);
        if (timeReduced.length == 0) {
            return;
        }
        double arcDistance = Math.acos(Math.cos(distRadian));
        double distDeg = arcDistance * 180.0 / Math.PI;
        out.println(Outputs.formatDistance(distDeg) + "  " + Outputs.formatTime(timeReduced[0]));
    }

    public static final boolean isBetween(double a, double b, double value) {
        return a < value && value < b || a > value && value > b;
    }

    @Override
    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (TauP_Curve.dashEquals("gmt", leftOverArgs[i])) {
                this.gmtScript = true;
                continue;
            }
            if (TauP_Curve.dashEquals("reddeg", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setReduceTime(true);
                this.setReduceVelDeg(Double.valueOf(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            if (TauP_Curve.dashEquals("redkm", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setReduceTime(true);
                this.setReduceVelKm(Double.valueOf(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            if (TauP_Curve.dashEquals("mapwidth", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setMapWidth(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = TauP_Curve.dashEquals("help", leftOverArgs[i]) ? leftOverArgs[i] : leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws IOException {
        ToolRun.legacyRunTool(ToolRun.CURVE, args);
    }
}

