/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import edu.sc.seis.seisFile.sac.Complex;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class SacPoleZero {
    private Complex[] poles;
    private Complex[] zeros;
    private float constant;
    static String POLES = "POLES";
    static String ZEROS = "ZEROS";
    static String CONSTANT = "CONSTANT";

    public SacPoleZero(BufferedReader in) throws IOException {
        this.read(in);
    }

    public SacPoleZero(String filename) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(filename));
        this.read(in);
        in.close();
    }

    public SacPoleZero(Complex[] poles, Complex[] zeros, float constant) {
        this.poles = poles;
        this.zeros = zeros;
        this.constant = constant;
    }

    public float getConstant() {
        return this.constant;
    }

    public Complex[] getPoles() {
        return this.poles;
    }

    public Complex[] getZeros() {
        return this.zeros;
    }

    public String toString() {
        int i;
        DecimalFormat formatter = new DecimalFormat(" 0.0000;-0.0000", new DecimalFormatSymbols(Locale.US));
        DecimalFormat constantFormatter = new DecimalFormat("0.0#######E00", new DecimalFormatSymbols(Locale.US));
        String out = ZEROS + " " + this.zeros.length + "\n";
        for (i = 0; i < this.zeros.length; ++i) {
            out = out + formatter.format(this.zeros[i].getReal()) + " " + formatter.format(this.zeros[i].getImaginary()) + "\n";
        }
        out = out + POLES + " " + this.poles.length + "\n";
        for (i = 0; i < this.poles.length; ++i) {
            out = out + formatter.format(this.poles[i].getReal()) + " " + formatter.format(this.poles[i].getImaginary()) + "\n";
        }
        out = out + CONSTANT + " " + constantFormatter.format(this.constant) + "\n";
        return out;
    }

    protected void read(BufferedReader in) throws IOException {
        String s;
        ArrayList<String> lines = new ArrayList<String>();
        while ((s = in.readLine()) != null) {
            lines.add(s.trim());
        }
        Complex[] poles = new Complex[]{};
        Complex[] zeros = new Complex[]{};
        float constant = 1.0f;
        Iterator<String> it = lines.iterator();
        String line = SacPoleZero.nextLine(it);
        while (!line.equals("")) {
            int i;
            String num;
            if (line.startsWith(POLES)) {
                num = line.substring(POLES.length()).trim();
                int numPoles = Integer.parseInt(num);
                poles = SacPoleZero.initCmplx(numPoles);
                line = SacPoleZero.nextLine(it);
                for (i = 0; i < poles.length && it.hasNext() && line.matches("^-?\\d+\\.\\d+\\s+-?\\d+\\.\\d+"); ++i) {
                    poles[i] = SacPoleZero.parseCmplx(line);
                    line = SacPoleZero.nextLine(it);
                }
                continue;
            }
            if (line.startsWith(ZEROS)) {
                num = line.substring(ZEROS.length()).trim();
                int numZeros = Integer.parseInt(num);
                zeros = SacPoleZero.initCmplx(numZeros);
                line = SacPoleZero.nextLine(it);
                for (i = 0; i < zeros.length && it.hasNext() && line.matches("^-?\\d+\\.\\d+\\s+-?\\d+\\.\\d+"); ++i) {
                    zeros[i] = SacPoleZero.parseCmplx(line);
                    line = SacPoleZero.nextLine(it);
                }
                continue;
            }
            if (line.startsWith(CONSTANT)) {
                line = line.replaceAll("\\s+", " ");
                String[] sline = line.split(" ");
                constant = Float.parseFloat(sline[1]);
                line = SacPoleZero.nextLine(it);
                continue;
            }
            throw new IOException("Unknown line in SAC polezero file: " + line);
        }
        this.poles = poles;
        this.zeros = zeros;
        this.constant = constant;
    }

    private static String nextLine(Iterator<String> it) {
        if (it.hasNext()) {
            return it.next();
        }
        return "";
    }

    public static Complex[] initCmplx(int length) {
        Complex[] out = new Complex[length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new Complex(0.0, 0.0);
        }
        return out;
    }

    static Complex parseCmplx(String line) throws IOException {
        line = line.trim().replaceAll("\\s+", " ");
        String[] sline = line.split(" ");
        return new Complex(Float.parseFloat(sline[0]), Float.parseFloat(sline[1]));
    }

    public boolean close(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SacPoleZero) {
            SacPoleZero spz = (SacPoleZero)obj;
            if (!SacPoleZero.close(spz.constant, this.constant)) {
                System.out.println("const not close");
                return false;
            }
            return this.closeButConstant(obj);
        }
        return false;
    }

    public boolean closeButConstant(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SacPoleZero) {
            int i;
            SacPoleZero spz = (SacPoleZero)obj;
            if (spz.poles.length != this.poles.length || spz.zeros.length != this.zeros.length) {
                return false;
            }
            for (i = 0; i < this.poles.length; ++i) {
                if (SacPoleZero.closeFourDigit(spz.poles[i], this.poles[i])) continue;
                System.out.println("pole " + i + " not equal" + spz.poles[i].getImaginary() + " " + this.poles[i].getImaginary() + " " + spz.poles[i].getReal() + " " + this.poles[i].getReal());
                return false;
            }
            for (i = 0; i < this.zeros.length; ++i) {
                if (SacPoleZero.closeFourDigit(spz.zeros[i], this.zeros[i])) continue;
                System.out.println("zero " + i + " not equal");
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean close(double a, double b) {
        if (Math.abs(a - b) / a > 1.0E-4) {
            System.out.println("fail close " + a + " " + b + " " + Math.abs(a - b) / a + " ratio=" + a / b);
            return false;
        }
        return true;
    }

    private static boolean closeFourDigit(Complex a, Complex b) {
        return SacPoleZero.closeFourDigit(a.getReal(), b.getReal()) && SacPoleZero.closeFourDigit(a.getImaginary(), b.getImaginary());
    }

    private static boolean closeFourDigit(double a, double b) {
        if (Math.abs(a - b) > 1.0E-4) {
            System.out.println("fail closeFourDigit " + a + " " + b + " " + Math.abs(a - b) + " ratio=" + a / b);
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SacPoleZero) {
            int i;
            SacPoleZero spz = (SacPoleZero)obj;
            if ((double)(Math.abs(spz.constant - this.constant) / this.constant) > 0.001) {
                return false;
            }
            if (spz.poles.length != this.poles.length || spz.zeros.length != this.zeros.length) {
                return false;
            }
            for (i = 0; i < this.poles.length; ++i) {
                if (spz.poles[i].getImaginary() == this.poles[i].getImaginary() && spz.poles[i].getReal() == this.poles[i].getReal()) continue;
                return false;
            }
            for (i = 0; i < this.zeros.length; ++i) {
                if (spz.zeros[i].getImaginary() == this.zeros[i].getImaginary() && spz.zeros[i].getReal() == this.zeros[i].getReal()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int j;
        int i = 17;
        i = 29 * i + this.poles.length;
        i = 31 * i + this.zeros.length;
        for (j = 0; j < this.poles.length; ++j) {
            i = 37 * i + this.poles[j].hashCode();
        }
        for (j = 0; j < this.zeros.length; ++j) {
            i = 43 * i + this.zeros[j].hashCode();
        }
        return i;
    }
}

