/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQuerier;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRecordIterator {
    DataRecord nextDr;
    DataInput in;
    private static final Logger logger = LoggerFactory.getLogger(DataRecordIterator.class);
    FDSNDataSelectQuerier querier;

    public DataRecordIterator(DataInput in) {
        this.in = in;
    }

    public boolean hasNext() throws SeedFormatException, IOException {
        if (this.in == null) {
            return false;
        }
        while (this.in != null && this.nextDr == null) {
            try {
                SeedRecord sr = SeedRecord.read(this.in);
                if (sr instanceof DataRecord) {
                    this.nextDr = (DataRecord)sr;
                    break;
                }
                logger.warn("Not a data record, skipping..." + sr.getControlHeader().getSequenceNum() + " " + sr.getControlHeader().getTypeCode());
            }
            catch (EOFException e) {
                this.in = null;
                this.nextDr = null;
                break;
            }
        }
        return this.nextDr != null;
    }

    public DataRecord next() throws SeedFormatException, IOException {
        if (this.hasNext()) {
            DataRecord out = this.nextDr;
            this.nextDr = null;
            return out;
        }
        return null;
    }

    public void close() {
        if (this.in != null && this.in instanceof DataInputStream) {
            try {
                ((DataInputStream)this.in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void setQuerier(FDSNDataSelectQuerier q) {
        this.querier = q;
    }
}

