/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette100;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.BlocketteUnknown;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.BtimeRange;
import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.DataBlocketteUnknown;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DataRecord
extends SeedRecord
implements Serializable {
    private static final ThreadLocal<DecimalFormat> decimalFormat = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("#####.####", new DecimalFormatSymbols(Locale.US));
        }
    };
    protected byte[] data;
    byte ZERO_BYTE = 0;

    public DataRecord(DataHeader header) {
        super(header);
    }

    public DataRecord(DataRecord record) {
        super(new DataHeader(record.getHeader().getSequenceNum(), record.getHeader().getTypeCode(), record.getHeader().isContinuation()));
        this.RECORD_SIZE = record.RECORD_SIZE;
        this.getHeader().setActivityFlags(record.getHeader().getActivityFlags());
        this.getHeader().setChannelIdentifier(record.getHeader().getChannelIdentifier());
        this.getHeader().setDataBlocketteOffset((short)record.getHeader().getDataBlocketteOffset());
        this.getHeader().setDataOffset((short)record.getHeader().getDataOffset());
        this.getHeader().setDataQualityFlags(record.getHeader().getDataQualityFlags());
        this.getHeader().setIOClockFlags(record.getHeader().getIOClockFlags());
        this.getHeader().setLocationIdentifier(record.getHeader().getLocationIdentifier());
        this.getHeader().setNetworkCode(record.getHeader().getNetworkCode());
        this.getHeader().setNumSamples((short)record.getHeader().getNumSamples());
        this.getHeader().setSampleRateFactor((short)record.getHeader().getSampleRateFactor());
        this.getHeader().setSampleRateMultiplier((short)record.getHeader().getSampleRateMultiplier());
        this.getHeader().setStartBtime(record.getHeader().getStartBtime());
        this.getHeader().setStationIdentifier(record.getHeader().getStationIdentifier());
        this.getHeader().setTimeCorrection(record.getHeader().getTimeCorrection());
        try {
            this.setData(record.getData());
            for (int j = 0; j < record.getBlockettes().length; ++j) {
                this.blockettes.add(record.getBlockettes()[j]);
            }
        }
        catch (SeedFormatException e) {
            throw new RuntimeException("Shouldn't happen as record was valid and we are copying it", e);
        }
    }

    @Override
    public void addBlockette(Blockette b) throws SeedFormatException {
        if (b == null) {
            throw new IllegalArgumentException("Blockette cannot be null");
        }
        if (b instanceof BlocketteUnknown) {
            b = new DataBlocketteUnknown(((BlocketteUnknown)b).info, b.getType(), ((BlocketteUnknown)b).getSwapBytes());
        }
        if (!(b instanceof DataBlockette)) {
            throw new SeedFormatException("Cannot add non-data blockettes to a DataRecord " + b.getType());
        }
        super.addBlockette(b);
        this.getHeader().setNumBlockettes((byte)(this.getHeader().getNumBlockettes() + 1));
        if (b instanceof Blockette1000) {
            this.setRecordSize(((Blockette1000)b).getLogicalRecordLength());
        }
        this.recheckDataOffset();
    }

    protected void recheckDataOffset() throws SeedFormatException {
        int size = this.getHeader().getSize();
        Blockette[] blocks = this.getBlockettes();
        for (int i = 0; i < blocks.length; ++i) {
            size += blocks[i].getSize();
        }
        if (this.data != null) {
            size += this.data.length;
        }
        if (size > this.RECORD_SIZE) {
            int headerSize = size;
            if (this.data != null) {
                headerSize = size - this.data.length;
            }
            throw new SeedFormatException("Can't fit blockettes and data in record " + headerSize + " + " + (this.data == null ? 0 : this.data.length) + " > " + this.RECORD_SIZE);
        }
        if (this.data != null) {
            this.getHeader().setDataOffset((short)(this.RECORD_SIZE - this.data.length));
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public DecompressedData decompress() throws SeedFormatException, UnsupportedCompressionType, CodecException {
        if (this.getHeader().getNumSamples() == 0) {
            return new DecompressedData(new int[0]);
        }
        Blockette1000 b1000 = (Blockette1000)this.getUniqueBlockette(1000);
        if (b1000 == null) {
            throw new MissingBlockette1000(this.getHeader());
        }
        Codec codec = new Codec();
        return codec.decompress((int)b1000.getEncodingFormat(), this.getData(), this.getHeader().getNumSamples(), b1000.isLittleEndian());
    }

    public void setData(byte[] data) throws SeedFormatException {
        this.data = data;
        this.recheckDataOffset();
    }

    public int getDataSize() {
        return this.data.length;
    }

    public float getSampleRate() {
        float sampleRate;
        Blockette[] blocketts = this.getBlockettes(100);
        if (blocketts.length != 0) {
            Blockette100 b100 = (Blockette100)blocketts[0];
            sampleRate = b100.getActualSampleRate();
        } else {
            sampleRate = this.getHeader().calcSampleRateFromMultipilerFactor();
        }
        return sampleRate;
    }

    private Btime getEndBtime() {
        Btime startBtime = this.getHeader().getStartBtime();
        double numTenThousandths = (double)this.getHeader().getNumSamples() / (double)this.getSampleRate() * 10000.0;
        this.getHeader();
        return DataHeader.projectTime(startBtime, numTenThousandths);
    }

    public Btime getPredictedNextStartBtime() {
        return this.getEndBtime();
    }

    public BtimeRange getBtimeRange() {
        return new BtimeRange(this.getHeader().getStartBtime(), this.getLastSampleBtime());
    }

    public Btime getLastSampleBtime() {
        Btime startBtime = this.getStartBtime();
        if (this.getHeader().getNumSamples() == 0) {
            return startBtime;
        }
        double numTenThousandths = (double)(this.getHeader().getNumSamples() - 1) / (double)this.getSampleRate() * 10000.0;
        return DataHeader.projectTime(startBtime, numTenThousandths);
    }

    public Btime getStartBtime() {
        return this.getHeader().getStartBtime();
    }

    public String getStartTime() {
        return this.getHeader().getStartTime();
    }

    public String getEndTime() {
        Btime endStruct = this.getEndBtime();
        DecimalFormat twoZero = new DecimalFormat("00");
        DecimalFormat threeZero = new DecimalFormat("000");
        DecimalFormat fourZero = new DecimalFormat("0000");
        return new String(fourZero.format(endStruct.year) + "," + threeZero.format(endStruct.jday) + "," + twoZero.format(endStruct.hour) + ":" + twoZero.format(endStruct.min) + ":" + twoZero.format(endStruct.sec) + "." + fourZero.format(endStruct.tenthMilli));
    }

    public String getLastSampleTime() {
        Btime endStruct = this.getLastSampleBtime();
        DecimalFormat twoZero = new DecimalFormat("00");
        DecimalFormat threeZero = new DecimalFormat("000");
        DecimalFormat fourZero = new DecimalFormat("0000");
        return new String(fourZero.format(endStruct.year) + "," + threeZero.format(endStruct.jday) + "," + twoZero.format(endStruct.hour) + ":" + twoZero.format(endStruct.min) + ":" + twoZero.format(endStruct.sec) + "." + fourZero.format(endStruct.tenthMilli));
    }

    public DataHeader getHeader() {
        return (DataHeader)this.header;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(byteStream);
            this.write(dos);
            dos.close();
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException, should not happen.", e);
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        int i;
        Blockette[] blocks = this.getBlockettes();
        this.getHeader().setNumBlockettes((byte)blocks.length);
        if (blocks.length != 0) {
            this.getHeader().setDataBlocketteOffset((short)48);
        }
        this.getHeader().write(dos);
        short blockettesSize = this.getHeader().getSize();
        for (i = 0; i < blocks.length; ++i) {
            DataBlockette dataB = (DataBlockette)blocks[i];
            blockettesSize = (short)(blockettesSize + (short)dataB.getSize());
            if (i != blocks.length - 1) {
                dos.write(dataB.toBytes(blockettesSize));
                continue;
            }
            dos.write(dataB.toBytes((short)0));
        }
        for (i = (int)blockettesSize; i < this.getHeader().getDataOffset(); ++i) {
            dos.write(this.ZERO_BYTE);
        }
        dos.write(this.data);
        int remainBytes = this.RECORD_SIZE - this.getHeader().getDataOffset() - this.data.length;
        for (int i2 = 0; i2 < remainBytes; ++i2) {
            dos.write(this.ZERO_BYTE);
        }
    }

    public void printData(PrintWriter out) {
        int i;
        byte[] d = this.getData();
        DecimalFormat byteFormat = new DecimalFormat("000");
        for (i = 0; i < d.length; ++i) {
            out.write(byteFormat.format(0xFF & d[i]) + " ");
            if (i % 4 == 3) {
                out.write("  ");
            }
            if (i % 16 != 15 || i == 0) continue;
            out.write("\n");
        }
        if (i % 16 != 15 && i != 0) {
            out.write("\n");
        }
    }

    public static SeedRecord readDataRecord(DataInput inStream, DataHeader header, int defaultRecordSize) throws IOException, SeedFormatException {
        try {
            byte[] timeseries;
            byte[] garbage;
            boolean swapBytes = header.flagByteSwap();
            DataRecord dataRec = new DataRecord(header);
            if (header.getDataBlocketteOffset() != 0) {
                if (header.getDataBlocketteOffset() < header.getSize()) {
                    throw new SeedFormatException("dataBlocketteOffset is smaller than header size: " + header.getDataBlocketteOffset());
                }
                if (header.getDataBlocketteOffset() > 4096 && header.getDataBlocketteOffset() > defaultRecordSize) {
                    throw new SeedFormatException("dataBlocketteOffset is large: " + header.getDataBlocketteOffset());
                }
                byte[] garbage2 = new byte[header.getDataBlocketteOffset() - header.getSize()];
                if (garbage2.length != 0) {
                    inStream.readFully(garbage2);
                }
            }
            int currOffset = header.getDataBlocketteOffset();
            if (header.getDataBlocketteOffset() == 0) {
                currOffset = header.getSize();
            }
            int recordSize = 0;
            for (int i = 0; i < header.getNumBlockettes(); ++i) {
                byte hibyteType = inStream.readByte();
                byte lowbyteType = inStream.readByte();
                int type = Utility.uBytesToInt(hibyteType, lowbyteType, swapBytes);
                byte hibyteOffset = inStream.readByte();
                byte lowbyteOffset = inStream.readByte();
                int nextOffset = Utility.uBytesToInt(hibyteOffset, lowbyteOffset, swapBytes);
                byte[] blocketteBytes = nextOffset != 0 ? new byte[nextOffset - currOffset] : (header.getNumSamples() != 0 && header.getDataOffset() > currOffset ? new byte[header.getDataOffset() - currOffset] : (header.getNumSamples() == 0 && i == header.getNumBlockettes() - 1 && recordSize > 0 ? new byte[recordSize - (currOffset += 4)] : new byte[]{}));
                inStream.readFully(blocketteBytes);
                currOffset = nextOffset != 0 ? nextOffset : (currOffset += blocketteBytes.length);
                byte[] fullBlocketteBytes = new byte[blocketteBytes.length + 4];
                System.arraycopy(blocketteBytes, 0, fullBlocketteBytes, 4, blocketteBytes.length);
                fullBlocketteBytes[0] = hibyteType;
                fullBlocketteBytes[1] = lowbyteType;
                fullBlocketteBytes[2] = hibyteOffset;
                fullBlocketteBytes[3] = lowbyteOffset;
                Blockette b = SeedRecord.getBlocketteFactory().parseBlockette(type, fullBlocketteBytes, swapBytes);
                if (b.getType() == 1000) {
                    recordSize = ((Blockette1000)b).getDataRecordLength();
                }
                dataRec.blockettes.add(b);
                if (nextOffset == 0) break;
            }
            try {
                recordSize = ((Blockette1000)dataRec.getUniqueBlockette(1000)).getDataRecordLength();
            }
            catch (MissingBlockette1000 e) {
                if (defaultRecordSize == 0) {
                    throw e;
                }
                recordSize = defaultRecordSize;
            }
            dataRec.RECORD_SIZE = recordSize;
            if (header.getDataOffset() != 0 && (garbage = new byte[header.getDataOffset() - currOffset]).length != 0) {
                inStream.readFully(garbage);
            }
            if (header.getDataOffset() == 0) {
                timeseries = new byte[recordSize - currOffset];
            } else {
                if (recordSize < header.getDataOffset()) {
                    throw new SeedFormatException("recordSize < header.getDataOffset(): " + recordSize + " < " + header.getDataOffset());
                }
                timeseries = new byte[recordSize - header.getDataOffset()];
            }
            inStream.readFully(timeseries);
            dataRec.setData(timeseries);
            return dataRec;
        }
        catch (SeedFormatException e) {
            e.setHeader(header);
            throw e;
        }
    }

    public void setRecordSize(int recordSize) throws SeedFormatException {
        int tmp = this.RECORD_SIZE;
        this.RECORD_SIZE = recordSize;
        try {
            this.recheckDataOffset();
        }
        catch (SeedFormatException e) {
            this.RECORD_SIZE = tmp;
            throw e;
        }
    }

    public static String oneLineSummaryKey() {
        return "Type Codes Start Duration Npts";
    }

    public String oneLineSummary() {
        String s = this.getHeader().getTypeCode() + " " + this.getHeader().getCodes() + " " + this.getStartTime() + "  " + decimalFormat.get().format((float)this.getHeader().getNumSamples() / this.getSampleRate()) + " " + this.getHeader().getNumSamples();
        return s;
    }

    @Override
    public String toString() {
        String s = super.toString();
        s = s + "    " + this.data.length + " bytes of data";
        return s;
    }
}

