/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.virtualnet;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class VirtualStation {
    String code;
    String vnetStart;
    String vnetEnd;
    String primaryDC;
    String certDate;
    String installDate;

    public VirtualStation(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("virtualNetwork", reader);
        this.code = StaxUtil.pullAttribute(startE, "code");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("vnetStart")) {
                    this.vnetStart = StaxUtil.pullText(reader, "vnetStart");
                    continue;
                }
                if (elName.equals("vnetEnd")) {
                    this.vnetEnd = StaxUtil.pullText(reader, "vnetEnd");
                    continue;
                }
                if (elName.equals("primary_dc")) {
                    this.primaryDC = StaxUtil.pullText(reader, "primary_dc");
                    continue;
                }
                if (elName.equals("certDate")) {
                    this.certDate = StaxUtil.pullText(reader, "certDate");
                    continue;
                }
                if (elName.equals("installDate")) {
                    this.installDate = StaxUtil.pullText(reader, "installDate");
                    continue;
                }
                System.err.println("VirtualNetwork skipping " + elName);
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getVnetStart() {
        return this.vnetStart;
    }

    public String getVnetEnd() {
        return this.vnetEnd;
    }

    public String getPrimaryDC() {
        return this.primaryDC;
    }

    public String getCertDate() {
        return this.certDate;
    }

    public String getInstallDate() {
        return this.installDate;
    }
}

