/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.virtualnet;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.virtualnet.VirtualStation;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ContributorNetwork {
    List<VirtualStation> stationList = new ArrayList<VirtualStation>();
    String startYear;
    String endYear;
    String nickname;
    String description;
    String code;

    public ContributorNetwork(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("virtualNetwork", reader);
        this.code = StaxUtil.pullAttribute(startE, "code");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("startYear")) {
                    this.startYear = StaxUtil.pullText(reader, "startYear");
                    continue;
                }
                if (elName.equals("endYear")) {
                    this.endYear = StaxUtil.pullText(reader, "endYear");
                    continue;
                }
                if (elName.equals("description")) {
                    this.description = StaxUtil.pullText(reader, "description");
                    continue;
                }
                if (elName.equals("nick_name")) {
                    this.nickname = StaxUtil.pullText(reader, "nick_name");
                    continue;
                }
                if (elName.equals("station")) {
                    this.stationList.add(new VirtualStation(reader));
                    break;
                }
                System.err.println("VirtualNetwork skipping " + elName);
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public List<VirtualStation> getStationList() {
        return this.stationList;
    }

    public String getStartYear() {
        return this.startYear;
    }

    public String getEndYear() {
        return this.endYear;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCode() {
        return this.code;
    }
}

