/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Site {
    String name;
    String description;
    String town;
    String county;
    String region;
    String country;

    Site() {
    }

    public Site(String name, String description, String town, String county, String region, String country) {
        this.name = name;
        this.description = description;
        this.town = town;
        this.county = county;
        this.region = region;
        this.country = country;
    }

    public Site(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Site", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Name")) {
                    this.name = StaxUtil.pullText(reader, "Name");
                    continue;
                }
                if (elName.equals("Description")) {
                    this.description = StaxUtil.pullText(reader, "Description");
                    continue;
                }
                if (elName.equals("Town")) {
                    this.town = StaxUtil.pullText(reader, "Town");
                    continue;
                }
                if (elName.equals("County")) {
                    this.county = StaxUtil.pullText(reader, "County");
                    continue;
                }
                if (elName.equals("Region")) {
                    this.region = StaxUtil.pullText(reader, "Region");
                    continue;
                }
                if (elName.equals("Country")) {
                    this.country = StaxUtil.pullText(reader, "Country");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTown() {
        return this.town;
    }

    public String getCounty() {
        return this.county;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCountry() {
        return this.country;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String toString() {
        return this.getName();
    }
}

