/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Person {
    String name;
    List<String> agencyList = new ArrayList<String>();
    List<String> emailList = new ArrayList<String>();
    List<String> phoneList = new ArrayList<String>();

    public Person(XMLEventReader reader, String tagName) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Name")) {
                    this.name = StaxUtil.pullText(reader, "Name");
                    continue;
                }
                if (elName.equals("Agency")) {
                    this.agencyList.add(StaxUtil.pullText(reader, "Agency"));
                    continue;
                }
                if (elName.equals("Email")) {
                    this.emailList.add(StaxUtil.pullText(reader, "Email"));
                    continue;
                }
                if (elName.equals("Phone")) {
                    this.phoneList.add(StaxUtil.pullText(reader, "Phone"));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAgencyList() {
        return this.agencyList;
    }

    public List<String> getEmailList() {
        return this.emailList;
    }

    public List<String> getPhoneList() {
        return this.phoneList;
    }
}

