/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQuerier;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FDSNStationXML {
    CloseableHttpResponse response;
    XMLEventReader reader;
    String source;
    String sender;
    String module;
    String moduleUri;
    String created;
    String xmlSchemaLocation;
    String schemaVersion;
    NetworkIterator networks;
    private static final Logger logger = LoggerFactory.getLogger(FDSNStationXML.class);
    FDSNStationQuerier fdsnStationQuerier;

    public FDSNStationXML(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        this.reader = reader;
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("FDSNStationXML", reader);
        Attribute schemaLocAttr = startE.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        this.xmlSchemaLocation = schemaLocAttr != null ? schemaLocAttr.getValue() : "http://www.fdsn.org/xml/station/1 http://www.fdsn.org/xml/station/fdsn-station-1.1.xsd";
        this.schemaVersion = StaxUtil.pullAttribute(startE, "schemaVersion");
        block16: while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName;
                switch (elName = e.asStartElement().getName().getLocalPart()) {
                    case "Source": {
                        this.source = StaxUtil.pullText(reader, "Source");
                        break;
                    }
                    case "Sender": {
                        this.sender = StaxUtil.pullText(reader, "Sender");
                        break;
                    }
                    case "Module": {
                        this.module = StaxUtil.pullText(reader, "Module");
                        break;
                    }
                    case "ModuleURI": {
                        this.moduleUri = StaxUtil.pullText(reader, "ModuleURI");
                        break;
                    }
                    case "Created": {
                        this.created = StaxUtil.pullText(reader, "Created");
                        break;
                    }
                    case "Network": {
                        this.networks = new NetworkIterator(reader);
                        break block16;
                    }
                    default: {
                        StaxUtil.skipToMatchingEnd(reader);
                        break;
                    }
                }
                continue;
            }
            if (e.isEndElement()) {
                return;
            }
            reader.nextEvent();
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public NetworkIterator getNetworks() {
        if (this.networks == null) {
            this.networks = new NetworkIterator(null){

                @Override
                public boolean hasNext() throws XMLStreamException {
                    return false;
                }

                @Override
                public Network next() throws XMLStreamException, StationXMLException {
                    throw new StationXMLException("No mo networks");
                }
            };
        }
        return this.networks;
    }

    public void closeReader() {
        if (this.fdsnStationQuerier != null) {
            this.fdsnStationQuerier.close();
            this.fdsnStationQuerier = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                logger.warn("problem closing underlying XMLEventReader.", (Throwable)e);
            }
        }
        this.reader = null;
        if (this.response != null) {
            try {
                this.response.close();
            }
            catch (IOException e) {
                FDSNStationXML.getLogger().warn("trouble closing HttpResponse", (Throwable)e);
            }
        }
        this.response = null;
    }

    public String getXmlSchemaLocation() {
        return this.xmlSchemaLocation;
    }

    public void setXmlSchemaLocation(String xmlns) {
        this.xmlSchemaLocation = xmlns;
    }

    public XMLEventReader getReader() {
        return this.reader;
    }

    public String getModuleUri() {
        return this.moduleUri;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public static Logger getLogger() {
        return logger;
    }

    public boolean checkSchemaVersion() {
        if (!this.xmlSchemaLocation.split(" ")[0].equals("http://www.fdsn.org/xml/station/1") && !this.xmlSchemaLocation.split(" ")[0].equals("http://www.fdsn.org/xml/station/1")) {
            return false;
        }
        return "1.1".equals(this.getSchemaVersion()) || "1.0".equals(this.getSchemaVersion());
    }

    public void setResponse(CloseableHttpResponse response) {
        this.response = response;
    }

    public static FDSNStationXML createEmpty() {
        try {
            URL url = FDSNStationXML.class.getClassLoader().getResource("edu/sc/seis/seisFile/stationxml/empty.stationxml");
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader r = factory.createXMLEventReader(url.toString(), url.openStream());
            return new FDSNStationXML(r);
        }
        catch (Exception e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public static URL findInternalSchema() {
        return FDSNStationXML.class.getClassLoader().getResource("edu/sc/seis/seisFile/stationxml/fdsn-station-1.1.xsd");
    }

    public static void printSchema(OutputStream out) throws IOException {
        BufferedInputStream bufIn = new BufferedInputStream(FDSNStationXML.findInternalSchema().openStream());
        BufferedOutputStream bufOut = new BufferedOutputStream(out);
        byte[] buf = new byte[1024];
        int numRead = bufIn.read(buf);
        while (numRead != -1) {
            bufOut.write(buf, 0, numRead);
            numRead = bufIn.read(buf);
        }
        bufIn.close();
        bufOut.flush();
    }

    public static FDSNStationXML loadStationXML(Reader streamReader) throws XMLStreamException, IOException, SeisFileException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader r = factory.createXMLEventReader(streamReader);
        XMLEvent e = r.peek();
        while (!e.isStartElement()) {
            r.nextEvent();
            e = r.peek();
        }
        System.out.println("StaMessage");
        FDSNStationXML fdsnStationXML = new FDSNStationXML(r);
        return fdsnStationXML;
    }

    public static FDSNStationXML loadStationXML(InputStream stream) throws XMLStreamException, IOException, SeisFileException {
        return FDSNStationXML.loadStationXML(new InputStreamReader(stream));
    }

    public static FDSNStationXML loadStationXML(String filename) throws XMLStreamException, IOException, SeisFileException {
        return FDSNStationXML.loadStationXML(new FileInputStream(filename));
    }

    public void setQuerier(FDSNStationQuerier fdsnStationQuerier) {
        this.fdsnStationQuerier = fdsnStationQuerier;
    }
}

