/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.Person;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Comment {
    String value;
    String beginEffectiveTime;
    String endEffectiveTime;
    int id;
    List<Person> authorList = new ArrayList<Person>();

    public Comment(String value) {
        this.value = value;
    }

    public Comment(XMLEventReader reader, String tagName) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (this.parseSubElement(elName, reader)) continue;
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    boolean parseSubElement(String elName, XMLEventReader reader) throws StationXMLException, XMLStreamException {
        if (elName.equals("Value")) {
            this.value = StaxUtil.pullText(reader, "Value");
            return true;
        }
        if (elName.equals("BeginEffectiveTime")) {
            this.beginEffectiveTime = StaxUtil.pullText(reader, "BeginEffectiveTime");
            return true;
        }
        if (elName.equals("EndEffectiveTime")) {
            this.endEffectiveTime = StaxUtil.pullText(reader, "EndEffectiveTime");
            return true;
        }
        if (elName.equals("Author")) {
            this.authorList.add(new Person(reader, "Author"));
            return true;
        }
        return false;
    }

    void parseAttributes(StartElement startE) throws StationXMLException {
        this.id = StaxUtil.pullIntAttribute(startE, "id");
    }

    public String getValue() {
        return this.value;
    }

    public String getBeginEffectiveTime() {
        return this.beginEffectiveTime;
    }

    public String getEndEffectiveTime() {
        return this.endEffectiveTime;
    }

    public int getId() {
        return this.id;
    }

    public List<Person> getAuthorList() {
        return this.authorList;
    }

    public String toString() {
        return this.value;
    }
}

