/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.Comment;
import edu.sc.seis.seisFile.fdsnws.stationxml.DataAvailability;
import edu.sc.seis.seisFile.fdsnws.stationxml.Identifier;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class BaseNodeType {
    String code;
    String startDate;
    String endDate;
    Instant startDateTime;
    Instant endDateTime;
    String historicalCode;
    String alternateCode;
    String restrictedStatus;
    String description;
    List<Comment> commentList = new ArrayList<Comment>();
    List<Identifier> identifierList = new ArrayList<Identifier>();
    DataAvailability dataAvailability;
    private int dbid;

    void parseAttributes(StartElement startE) throws StationXMLException {
        this.code = StaxUtil.pullAttribute(startE, "code");
        this.startDate = StaxUtil.pullAttributeIfExists(startE, "startDate");
        this.endDate = StaxUtil.pullAttributeIfExists(startE, "endDate");
        this.historicalCode = StaxUtil.pullAttributeIfExists(startE, "historicalCode");
        this.alternateCode = StaxUtil.pullAttributeIfExists(startE, "alternateCode");
        this.restrictedStatus = StaxUtil.pullAttributeIfExists(startE, "restrictedStatus");
    }

    boolean parseSubElement(String elName, XMLEventReader reader) throws StationXMLException, XMLStreamException {
        if (elName.equals("Description")) {
            this.description = StaxUtil.pullText(reader, "Description");
            return true;
        }
        if (elName.equals("Comment")) {
            this.commentList.add(new Comment(reader, "Comment"));
            return true;
        }
        if (elName.equals("DataAvailability")) {
            this.dataAvailability = new DataAvailability(reader);
            return true;
        }
        if (elName.equals("Identifier")) {
            this.identifierList.add(new Identifier(reader, "Identifier"));
            return true;
        }
        return false;
    }

    public String getCode() {
        return this.code;
    }

    public String getStartDate() {
        if (this.startDate == null && this.startDateTime != null) {
            this.startDate = TimeUtils.toISOString(this.getStartDateTime());
        }
        return this.startDate;
    }

    public String getEndDate() {
        if (this.endDate == null && this.endDateTime != null) {
            this.endDate = TimeUtils.toISOString(this.getEndDateTime());
        }
        return this.endDate;
    }

    public String getHistoricalCode() {
        return this.historicalCode;
    }

    public String getAlternateCode() {
        return this.alternateCode;
    }

    public String getRestrictedStatus() {
        return this.restrictedStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public List<Identifier> getIdentifierList() {
        return this.identifierList;
    }

    public DataAvailability getDataAvailability() {
        return this.dataAvailability;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
        this.startDateTime = null;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
        this.endDateTime = null;
    }

    public void setHistoricalCode(String historicalCode) {
        this.historicalCode = historicalCode;
    }

    public void setAlternateCode(String alternateCode) {
        this.alternateCode = alternateCode;
    }

    public void setRestrictedStatus(String restrictedStatus) {
        this.restrictedStatus = restrictedStatus;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCommentList(List<Comment> commentList) {
        this.commentList = commentList;
    }

    public void addComment(Comment comment) {
        this.commentList.add(comment);
    }

    public void setDataAvailability(DataAvailability dataAvailability) {
        this.dataAvailability = dataAvailability;
    }

    public Instant getStartDateTime() {
        if (this.startDateTime == null && this.startDate != null) {
            this.startDateTime = TimeUtils.parseISOString(this.getStartDate());
        }
        return this.startDateTime;
    }

    public void setStartDateTime(Instant startDateTime) {
        this.startDateTime = startDateTime;
        this.startDate = null;
    }

    public Instant getEndDateTime() {
        if (this.endDateTime == null && this.endDate != null) {
            this.endDateTime = TimeUtils.parseISOString(this.getEndDate());
        }
        return this.endDateTime;
    }

    public void setEndDateTime(Instant endDateTime) {
        this.endDateTime = endDateTime;
        this.endDate = null;
    }

    public int getDbid() {
        return this.dbid;
    }

    void setDbid(int i) {
        this.dbid = i;
    }
}

