/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TimeUtils {
    public static final String DASH = "-";
    public static final ZoneId TZ_UTC = ZoneId.of("UTC");
    public static final String ZULU = "Z";
    public static final Duration ONE_MICROSECOND = Duration.ofNanos(1000L);
    public static final Duration ONE_MILLISECOND = Duration.ofMillis(1L);
    public static final Duration ONE_SECOND = Duration.ofSeconds(1L);
    public static final Duration ONE_MINUTE = Duration.ofMinutes(1L);
    public static final Duration ONE_HOUR = Duration.ofHours(1L);
    public static final Duration ONE_DAY = Duration.ofDays(1L);
    public static final Duration ONE_WEEK = Duration.ofDays(7L);
    public static final Duration ONE_FORTNIGHT = Duration.ofDays(14L);
    public static final Duration ONE_MONTH = Duration.ofDays(30L);
    public static final Duration ZERO_DURATION = Duration.ofNanos(0L);
    public static final int NANOS_IN_SEC_INT = 1000000000;
    public static final double NANOS_IN_SEC = 1.0E9;
    public static final int NANOS_IN_MILLI = 1000000;
    public static final int NANOS_IN_TENTH_MILLI = 100000;
    public static final Duration TENTH_MILLI = Duration.ofNanos(100000L);
    public static final int SECS_IN_DAY = 86400;
    public static final Instant wayPast = TimeUtils.parseISOString("1099-01-01T00:00:00.000000Z");
    public static final Instant future = TimeUtils.parseISOString("2499-01-01T00:00:00.000000Z");
    public static final Instant futurePlusOne = TimeUtils.parseISOString("2499-01-02T00:00:00.000000Z");

    public static DateTimeFormatter getDateTimeFormatter() {
        return DateTimeFormatter.ISO_INSTANT;
    }

    public static Instant parseISOString(String time) {
        if (time.charAt(8) == 'T') {
            time = time.substring(0, 4) + DASH + time.substring(4, 6) + DASH + time.substring(6);
        }
        if (!time.endsWith(ZULU)) {
            time = time + ZULU;
        }
        return Instant.parse(time);
    }

    public static String toISOString(Instant time) {
        return TimeUtils.getDateTimeFormatter().format(time);
    }

    public static Duration durationFromSeconds(double seconds) {
        return Duration.ofNanos(Math.round(1.0E9 * seconds));
    }

    public static double durationToDoubleSeconds(Duration d) {
        return (double)d.toNanos() / 1.0E9;
    }

    public static float durationToFloatDays(Duration d) {
        return (float)((double)d.toNanos() / 1.0E9 / 86400.0);
    }

    public static Instant instantFromEpochSeconds(double epochSec) {
        double epochEvenSeconds = Math.floor(epochSec);
        return Instant.ofEpochSecond(Math.round(epochEvenSeconds), Math.round(1.0E9 * (epochSec - epochEvenSeconds)));
    }

    public static double instantToEpochSeconds(Instant instant) {
        return (double)instant.getEpochSecond() + (double)instant.getNano() / 1.0E9;
    }

    public static Duration multiply(Duration dur, double value) {
        return Duration.ofNanos(Math.round((double)dur.toNanos() * value));
    }

    public static Duration divide(Duration dur, double value) {
        return Duration.ofNanos(Math.round((double)dur.toNanos() / value));
    }

    public static DateTimeFormatter createFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern).withZone(TZ_UTC);
    }
}

